---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-Jenkins本体

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（API応答時間100ms）**：具体的な数値の根拠が不明確
  2. **同時接続数の制限**：JVM設定依存とあるが具体的な計算式なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/model/Jenkins.java` - Jenkinsコアクラス
- E-02: `core/src/main/java/hudson/init/InitMilestone.java` - 初期化マイルストーン定義
- E-03: `core/src/main/java/hudson/PluginManager.java` - プラグインマネージャー
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-06: `core/src/main/java/hudson/model/Queue.java` - キュー管理
- E-07: `core/src/main/java/hudson/security/SecurityRealm.java` - セキュリティレルム（参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JenkinsはCI/CDプラットフォームのコア | E-01, E-04 | ○ |
| C-02 | jenkins.model.JenkinsがルートオブジェクトでJavaDoc@350に記載 | E-01 | ○ |
| C-03 | シングルトンパターンでtheInstanceフィールドが単一インスタンス | E-01 (495行目) | ○ |
| C-04 | get()メソッドでシングルトンアクセス | E-01 (803-810行目) | ○ |
| C-05 | numExecutorsフィールドがデフォルト2 | E-01 (400行目) | ○ |
| C-06 | modeがNORMAL/EXCLUSIVEのenum | E-01 (405行目) | ○ |
| C-07 | InitMilestoneに基づく段階的初期化 | E-01, E-02 | ○ |
| C-08 | PLUGINS_LISTED等の初期化段階が存在 | E-02 | ○ |
| C-09 | queueフィールドでビルドキューを管理 | E-01 (359行目), E-06 | ○ |
| C-10 | itemsマップでジョブを管理 | E-01 (490行目) | ○ |
| C-11 | computersマップでコンピューター管理 | E-01 (547行目) | ○ |
| C-12 | cloudsでCloud管理 | E-01 (552行目) | ○ |
| C-13 | PluginManagerで拡張機能管理 | E-01 (637行目), E-03 | ○ |
| C-14 | authorizationStrategyで認可管理 | E-01 (425行目) | ○ |
| C-15 | securityRealmで認証管理 | E-01 (442行目) | ○ |
| C-16 | crumbIssuerでCSRF保護 | E-01 (674行目) | ○ |
| C-17 | secret.keyで暗号化キー管理 | E-01 (936-948行目) | ○ |
| C-18 | config.xmlに設定永続化 | E-01 (XmlFile使用) | ○ |
| C-19 | slaveAgentPortでTCPエージェントポート設定 | E-01 (653行目) | ○ |
| C-20 | quietPeriodでデフォルト待機時間設定 | E-01 (600行目) | ○ |
| C-21 | 関連画面（システム設定等）が画面機能マッピングと一致 | E-05 | ○ |
| C-22 | ADMINISTERパーミッションが必要 | E-01 (Permission使用) | ○ |
| C-23 | BulkChangeでバッチ処理 | E-01 (import文) | ○ |
| C-24 | API応答時間100ms以内 | **根拠なし** | △ |
| C-25 | 同時接続数がJVM設定依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値根拠がソースコードに見当たらない
  - 候補：パフォーマンステスト結果 / JMeterレポート / 運用実績データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能概要、入出力仕様、処理フローはコードと整合
- 1: 中リスク - パフォーマンス要件は経験則に基づく可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] Jenkins.javaのフィールド定義が設計書と一致しているか確認
- [ ] InitMilestoneの順序が正確か確認
- [ ] パフォーマンス要件（100ms）の妥当性を運用チームに確認
- [ ] セキュリティ関連の記述が最新のセキュリティ設計と整合しているか確認
