---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-エージェントノード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/model/Slave.java` - Slaveクラス
- E-02: `core/src/main/java/hudson/model/Node.java` - Nodeクラス
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SlaveはNode継承、Serializable実装 | E-01 (107行目) | ○ |
| C-02 | nameフィールド（protected） | E-01 (114行目) | ○ |
| C-03 | descriptionフィールド | E-01 (119行目) | ○ |
| C-04 | remoteFSフィールド（final） | E-01 (129行目) | ○ |
| C-05 | numExecutorsフィールド（デフォルト1） | E-01 (134行目) | ○ |
| C-06 | modeフィールド（デフォルトNORMAL） | E-01 (139行目) | ○ |
| C-07 | retentionStrategyフィールド | E-01 (144行目) | ○ |
| C-08 | launcherフィールド | E-01 (149行目) | ○ |
| C-09 | labelフィールド | E-01 (154行目) | ○ |
| C-10 | nodePropertiesフィールド（DescribableList） | E-01 (156-157行目) | ○ |
| C-11 | userIdフィールド（非推奨） | E-01 (163行目) | ○ |
| C-12 | コンストラクタでname/remoteFS/launcher必須 | E-01 (184-189行目) | ○ |
| C-13 | getLauncher()でJNLPLauncherフォールバック | E-01 (242-253行目) | ○ |
| C-14 | save()でconfig.xml保存 | E-01 (258-262行目) | ○ |
| C-15 | getRemoteFS()でremoteFSアクセス | E-01 (268-270行目) | ○ |
| C-16 | getNodeName()でnameアクセス | E-01 (274-276行目) | ○ |
| C-17 | toString()でクラス名とname表示 | E-01 (278-280行目) | ○ |
| C-18 | getNumExecutors()でnumExecutorsアクセス | E-01 (298-300行目) | ○ |
| C-19 | 2016年の名称変更（slave→agent） | E-01 (99-102行目 JavaDoc) | ○ |
| C-20 | 関連画面（ノード一覧、ノード設定等）と整合 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目がソースコードと整合

## 6) レビュアーチェックリスト（最小）
- [ ] Slave.javaの主要フィールドがドキュメントでカバーされているか確認
- [ ] Node.javaとの継承関係が正確か確認
- [ ] ComputerLauncherの各実装について把握
- [ ] 画面機能マッピングとの整合性確認
