---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-クラウドプロビジョニング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **各クラウドプロバイダプラグインとの連携仕様**：具体的なプラグイン実装は本コアソースに含まれない
  2. **CloudSlaveRetentionStrategyの動作詳細**：別ファイルの詳細解析が必要
  3. **パフォーマンス要件の実測値**：設定値は確認済みだが実測値は未検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/slaves/Cloud.java`（1-405行目）
- E-02: `core/src/main/java/hudson/slaves/NodeProvisioner.java`（1-919行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面No.26-27）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能No.11）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Cloudクラスはノードの動的プロビジョニングを担当する抽象基底クラスである | E-01: 68-110行目 Javadoc | ○ |
| C-02 | NodeProvisionerがLoadStatisticsを使用して負荷分析を行う | E-02: 66-72行目、131行目 | ○ |
| C-03 | Cloud.PROVISION権限がプロビジョニング操作を制御する | E-01: 279-281行目 | ○ |
| C-04 | PlannedNodeクラスで非同期プロビジョニングを管理 | E-02: 76-126行目 | ○ |
| C-05 | NodeProvisionerInvokerが10秒間隔で定期実行 | E-02: 806-808行目 RECURRENCEPERIOD | ○ |
| C-06 | MARGIN閾値はデフォルト10%（0.1） | E-02: 830行目 | ○ |
| C-07 | EMAによる一時的負荷変動の吸収 | E-02: 153-160行目、629-660行目コメント | ○ |
| C-08 | Cloud.canProvision()でプロビジョニング可否を判定 | E-01: 235-249行目 | ○ |
| C-09 | Cloud.provision()でPlannedNodeを返却 | E-01: 200-229行目 | ○ |
| C-10 | Jenkins.addNode()でノードを登録 | E-02: 250行目 | ○ |
| C-11 | provisioningLockによる排他制御 | E-02: 144行目、216-217行目 | ○ |
| C-12 | CloudProvisioningListenerでイベント監視が可能 | E-02: 848-918行目 fireOnXxx系メソッド | ○ |
| C-13 | CloudStateがprovision()のパラメータオブジェクト | E-01: 372-404行目 | ○ |
| C-14 | StandardStrategyImplが標準プロビジョニング戦略 | E-02: 624-794行目 | ○ |
| C-15 | INITIALDELAY=10秒の初期遅延 | E-02: 806行目 | ○ |
| C-16 | suggestReviewNow()に1秒のスロットリング | E-02: 184-205行目 | ○ |
| C-17 | 画面No.26-27がクラウド設定画面として関連 | E-03 | ○ |
| C-18 | AWS、Azure、Kubernetes等との具体的な連携処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 各クラウドプロバイダ（AWS EC2、Azure VM、Kubernetes）との具体的なAPI連携処理
  - 候補：amazon-ec2プラグイン / azure-vm-agentsプラグイン / kubernetesプラグイン
  - 理由：コア機能には抽象インターフェースのみが定義され、具体実装は外部プラグインに存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な主張はすべてソースコードで確認可能
- 1: 中リスク - プラグインとの連携仕様は別途確認が必要
- 0: 低リスク - セキュリティ関連（PROVISION権限）はソースで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Cloud.java の provision() / canProvision() メソッドのシグネチャと戻り値を確認
- [ ] NodeProvisioner.StandardStrategyImpl.apply() の負荷判定ロジックを確認
- [ ] MARGIN / MARGIN0 / MARGIN_DECAY の計算式が設計書と一致することを確認
- [ ] Cloud.PROVISION 権限の定義と使用箇所を確認
- [ ] CloudProvisioningListener の拡張ポイントが正しく記述されているか確認
