---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-コンピューター管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **全主張が根拠付きで確認済み**
  2. **特になし**
  3. **特になし**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/model/Computer.java`（1-1800行目）
- E-02: `core/src/main/java/hudson/model/ComputerSet.java`（1-583行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面No.21-25）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能No.12）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Computerクラスはノードの実行時状態を管理する | E-01: 146-173行目 Javadoc | ○ |
| C-02 | ExecutorはCopyOnWriteArrayListで保持される | E-01: 175-177行目 | ○ |
| C-03 | offlineCauseでオフライン理由を記録 | E-01: 184行目 | ○ |
| C-04 | connect()でconnectTimeを記録 | E-01: 440-443行目 | ○ |
| C-05 | _connect()は抽象メソッドでサブクラスが実装 | E-01: 464行目 | ○ |
| C-06 | disconnect()でrecordTermination()を呼び出し | E-01: 503行目、520行目 | ○ |
| C-07 | setNumExecutors()はQueue.withLock内でExecutorを操作 | E-01: 869-875行目 | ○ |
| C-08 | doConfigSubmit()でNode.reconfigure()を呼び出し | E-01: 1506行目 | ○ |
| C-09 | doDoDelete()でJenkins.removeNode()を呼び出し | E-01: 1585行目 | ○ |
| C-10 | Computer.CONFIGURE権限でノード設定変更を制御 | E-01: 1740-1746行目 | ○ |
| C-11 | Computer.CONNECT権限で接続開始を制御 | E-01: 1779-1785行目 | ○ |
| C-12 | Computer.DISCONNECT権限で切断を制御 | E-01: 1772-1778行目 | ○ |
| C-13 | Computer.DELETE権限で削除を制御 | E-01: 1758-1764行目 | ○ |
| C-14 | statusChangeLockでオンライン/オフライン同期 | E-01: 210行目、1597-1608行目 | ○ |
| C-15 | threadPoolForRemotingはキャッシュスレッドプール | E-01: 1354-1362行目 | ○ |
| C-16 | ComputerSetは/computer/ URLのルート | E-02: 82-90行目 Javadoc | ○ |
| C-17 | getComputers()でソート済みComputer一覧を取得 | E-02: 133-135行目 | ○ |
| C-18 | doCreateItem()で新規ノード作成 | E-02: 279-356行目 | ○ |
| C-19 | getMonitorData()でNodeMonitorデータを取得 | E-01: 1131-1139行目 | ○ |
| C-20 | ログは$JENKINS_HOME/logs/slaves/{nodeName}/slave.logに出力 | E-01: 310-312行目、321-331行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張に対してソースコードから根拠を確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み
- 0: 低リスク - 権限定義も全てソースで確認済み
- 0: 低リスク - 処理フローもソースコードで追跡可能

## 6) レビュアーチェックリスト（最小）
- [ ] Computer.connect()/_connect()の実装パターンを確認
- [ ] setNumExecutors()のQueue.withLock使用を確認
- [ ] doConfigSubmit()のバリデーションロジックを確認
- [ ] Computer.PERMISSIONS グループの全権限定義を確認
- [ ] ComputerSet.getComputers()のソート条件を確認
