---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-ノードモニター

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **全主張が根拠付きで確認済み**
  2. **特になし**
  3. **特になし**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/node_monitors/NodeMonitor.java`（1-157行目）
- E-02: `core/src/main/java/hudson/node_monitors/AbstractNodeMonitorDescriptor.java`（1-345行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面No.21, 28）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能No.13）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NodeMonitorはExtensionPointを実装する | E-01: 72行目 | ○ |
| C-02 | ignoredフラグでオフライン化を抑制 | E-01: 73行目、133-140行目 | ○ |
| C-03 | triggerUpdate()でgetDescriptor().triggerUpdate()に委譲 | E-01: 108-110行目 | ○ |
| C-04 | data()でgetDescriptor().get(c)に委譲 | E-01: 94-96行目 | ○ |
| C-05 | getAll()でComputerSet.getMonitors().toList()を返却 | E-01: 116-118行目 | ○ |
| C-06 | PERIOD=60分がデフォルト間隔 | E-02: 57行目 | ○ |
| C-07 | schedule()でTimer.get().scheduleAtFixedRate()を呼び出し | E-02: 117-123行目 | ○ |
| C-08 | triggerUpdate()で既存スレッドの中断判定を実行 | E-02: 272-287行目 | ○ |
| C-09 | monitor()でJenkins.get().getComputers()を巡回 | E-02: 167行目 | ○ |
| C-10 | getMonitoringTimeOut()のデフォルトは30秒 | E-02: 299-301行目 | ○ |
| C-11 | markOffline()でc.setTemporaryOfflineCause()を呼び出し | E-02: 250行目 | ○ |
| C-12 | markOffline()でMonitorMarkedNodeOfflineに通知 | E-02: 253-255行目 | ○ |
| C-13 | markOnline()でc.setTemporaryOfflineCause(null)を呼び出し | E-02: 236行目 | ○ |
| C-14 | Recordクラスが監視スレッドとデータ構造を兼ねる | E-02: 307-342行目 | ○ |
| C-15 | record.dataに監視結果をMap形式で保持 | E-02: 311行目 | ○ |
| C-16 | get()でrecord.data.get(c)から結果取得 | E-02: 190-197行目 | ○ |
| C-17 | canTakeOffline()でオフライン化能力を表明 | E-02: 78-80行目 | ○ |
| C-18 | inProgressはsynchronizedで排他管理 | E-02: 136-137行目、271行目、336-339行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張に対してソースコードから根拠を確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み
- 0: 低リスク - 定期実行ロジックも詳細に追跡可能
- 0: 低リスク - オフライン処理のフローも確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] NodeMonitor.triggerUpdate()がDescriptorに委譲していることを確認
- [ ] AbstractNodeMonitorDescriptor.PERIOD の値と設定方法を確認
- [ ] triggerUpdate()のスレッド中断判定ロジックを確認
- [ ] markOffline()のMonitorMarkedNodeOffline通知を確認
- [ ] Recordクラスのrun()メソッドでmonitor()呼び出しを確認
