---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-シェルスクリプト実行

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. **全主張が根拠付きで確認済み**
  2. **特になし**
  3. **特になし**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/tasks/Shell.java`（1-264行目）
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面No.8, 31）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能No.15）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ShellはCommandInterpreterを継承 | E-01: 63行目 | ○ |
| C-02 | コンストラクタでUnix改行に変換 | E-01: 67行目 | ○ |
| C-03 | ファイル拡張子は.sh | E-01: 118-120行目 | ○ |
| C-04 | shebangでインタプリタを指定可能 | E-01: 100-107行目 | ○ |
| C-05 | デフォルトシェルはgetShellOrDefault()で取得 | E-01: 109行目、184-199行目 | ○ |
| C-06 | デフォルトオプションは-xe | E-01: 109行目 | ○ |
| C-07 | Unix/Windows判定はShellinterpreterで実行 | E-01: 250-258行目 | ○ |
| C-08 | Unixでは/bin/sh、Windowsではsh | E-01: 179行目、256行目 | ○ |
| C-09 | unstableReturnで特定終了コードをUNSTABLEに | E-01: 133-135行目 | ○ |
| C-10 | unstableReturnの有効範囲は1-255 | E-01: 230-232行目 | ○ |
| C-11 | 非ASCII対応でスクリプト先頭に改行追加 | E-01: 88-96行目 | ○ |
| C-12 | @Symbol("shell")でPipelineから参照可能 | E-01: 150行目 | ○ |
| C-13 | PersistentDescriptorで設定自動永続化 | E-01: 151行目 | ○ |
| C-14 | doCheckShellでシェルパス存在確認 | E-01: 245-248行目 | ○ |
| C-15 | configuredLocalRulesで環境変数フィルタ設定可能 | E-01: 75-79行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張に対してソースコードから根拠を確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み
- 0: 低リスク - shebang処理のロジックも確認済み
- 0: 低リスク - バリデーション処理も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Shell(String)コンストラクタのLineEndingConversion呼び出しを確認
- [ ] buildCommandLine()のshebang判定ロジックを確認
- [ ] getShellOrDefault(VirtualChannel)のリモート判定を確認
- [ ] addLineFeedForNonASCII()の非ASCII対応ロジックを確認
- [ ] doCheckUnstableReturn()のバリデーション範囲を確認
