---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-Mavenビルド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **全主張が根拠付きで確認済み**
  2. **特になし**
  3. **特になし**

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/tasks/Maven.java`（1-807行目）
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面No.8, 30）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能No.17）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MavenはBuilderを継承 | E-01: 90行目 | ○ |
| C-02 | @DataBoundConstructorで設定バインディング | E-01: 176-177行目 | ○ |
| C-03 | targetsはSPまたはNLで区切り可能 | E-01: 93-95行目 Javadoc | ○ |
| C-04 | usePrivateRepositoryで-Dmaven.repo.local追加 | E-01: 356-357行目 | ○ |
| C-05 | パイプ(\|)でターゲットを分割して複数実行 | E-01: 302-379行目 | ○ |
| C-06 | DecideDefaultMavenCommandでmvn/maven判定 | E-01: 252-288行目 | ○ |
| C-07 | project.xml存在でMaven1と判定 | E-01: 283行目 | ○ |
| C-08 | mi.forNode()でノード固有パス解決 | E-01: 319行目 | ○ |
| C-09 | mi.forEnvironment()で環境変数展開 | E-01: 320行目 | ○ |
| C-10 | S_PATTERNで-sオプション重複チェック | E-01: 157行目、332行目 | ○ |
| C-11 | GS_PATTERNで-gsオプション重複チェック | E-01: 158行目、338行目 | ○ |
| C-12 | MavenInstallation.buildEnvVars()でM2_HOME等設定 | E-01: 540-548行目 | ○ |
| C-13 | MAVEN_TERMINATE_CMD=onを設定 | E-01: 407行目 | ○ |
| C-14 | MavenConsoleAnnotatorでログ装飾 | E-01: 368行目 | ○ |
| C-15 | sensitiveVarsでパスワードマスキング | E-01: 345行目、349行目、354行目 | ○ |
| C-16 | @Symbol("maven")でPipelineから参照可能 | E-01: 428行目 | ○ |
| C-17 | MavenInstallerで自動インストールサポート | E-01: 761-780行目 | ○ |
| C-18 | MAVEN_20/21/30バージョン定数 | E-01: 500-502行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張に対してソースコードから根拠を確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み
- 0: 低リスク - 複雑なperform()メソッドも詳細に追跡可能

## 6) レビュアーチェックリスト（最小）
- [ ] Maven.perform()のパイプ区切りループを確認
- [ ] DecideDefaultMavenCommand.invoke()のMaven1/2判定を確認
- [ ] MavenInstallation.buildEnvVars()の環境変数設定を確認
- [ ] S_PATTERN/GS_PATTERNによるsettingsオプション重複チェックを確認
- [ ] sensitiveVarsの使用箇所を確認
