---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-成果物アーカイブ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. **全主張が根拠付きで確認済み**
  2. **特になし**
  3. **特になし**

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/tasks/ArtifactArchiver.java`（1-425行目）
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面No.8, 10）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能No.18）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ArtifactArchiverはRecorderを継承しSimpleBuildStepを実装 | E-01: 73行目 | ○ |
| C-02 | artifactsパターンはカンマまたはスペース区切り | E-01: 78-80行目 Javadoc | ○ |
| C-03 | 空artifactsはAbortException | E-01: 238-240行目 | ○ |
| C-04 | onlyIfSuccessfulでResult.UNSTABLE未満はスキップ | E-01: 243-246行目 | ○ |
| C-05 | ListFilesでFileSetによるパターンマッチング | E-01: 255行目、313-316行目 | ○ |
| C-06 | ArtifactManager.archive()でアーカイブ | E-01: 257行目 | ○ |
| C-07 | fingerprint=trueでFingerprinter実行 | E-01: 258-264行目 | ○ |
| C-08 | allowEmptyArchive=falseでマッチ0件はAbortException | E-01: 280行目 | ○ |
| C-09 | defaultExcludesのデフォルトはtrue | E-01: 107行目 | ○ |
| C-10 | caseSensitiveのデフォルトはtrue | E-01: 113行目 | ○ |
| C-11 | followSymlinksのデフォルトはtrue | E-01: 119行目 | ○ |
| C-12 | BuildStepMonitor.NONEを返す | E-01: 327-329行目 | ○ |
| C-13 | @Symbol("archiveArtifacts")でPipelineから参照可能 | E-01: 340行目 | ○ |
| C-14 | Migratorでlatestonly設定からLogRotatorへ移行 | E-01: 380-422行目 | ○ |
| C-15 | AccessDeniedExceptionをAbortExceptionに変換 | E-01: 289-291行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張に対してソースコードから根拠を確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み
- 0: 低リスク - perform()メソッドの全分岐を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ArtifactArchiver.perform()の空artifactsチェックを確認
- [ ] onlyIfSuccessfulによるスキップ条件を確認
- [ ] ListFiles.invoke()のFileSet使用を確認
- [ ] fingerprint=trueでのFingerprinter呼び出しを確認
- [ ] allowEmptyArchiveの動作を確認
