---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：2-プラグインマネージャー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **プラグインロードのパフォーマンス（数十秒）**：具体的な計測値の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/PluginManager.java` - プラグインマネージャー抽象クラス
- E-02: `core/src/main/java/hudson/PluginWrapper.java` - プラグインラッパー（参照）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-05: `core/src/main/java/hudson/util/CyclicGraphDetector.java` - 循環依存検出（参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PluginManagerはPluginWrapperを管理 | E-01 (183-205行目) | ○ |
| C-02 | 抽象クラスとして定義 | E-01 (205行目 abstract class) | ○ |
| C-03 | CUSTOM_PLUGIN_MANAGERシステムプロパティで差し替え可能 | E-01 (207行目) | ○ |
| C-04 | CHECK_UPDATE_SLEEP_TIME_MILLISでリトライ間隔設定 | E-01 (214行目) | ○ |
| C-05 | CHECK_UPDATE_ATTEMPTSでリトライ回数設定 | E-01 (219行目) | ○ |
| C-06 | デフォルトリトライ1回、間隔1000ms | E-01 (232-238行目) | ○ |
| C-07 | PMConstructor enumでコンストラクタ探索 | E-01 (243-290行目) | ○ |
| C-08 | createDefault()でデフォルトPluginManager生成 | E-01 (299行目) | ○ |
| C-09 | CLASS_PREFIXES_TO_SKIPでスキップ対象定義 | E-01 (224-227行目) | ○ |
| C-10 | 関連画面がプラグイン管理系画面（37-42） | E-04 | ○ |
| C-11 | .hpi/.jpi拡張子のプラグインファイル | E-01 (プラグインファイル操作ロジック) | ○ |
| C-12 | 循環依存検出はCyclicGraphDetector使用 | E-01 (import文), E-05 | ○ |
| C-13 | MissingDependencyExceptionで依存エラー | E-01 (import jenkins.MissingDependencyException) | ○ |
| C-14 | RestartRequiredExceptionで再起動要求 | E-01 (import jenkins.RestartRequiredException) | ○ |
| C-15 | UberClassLoaderで全プラグインクラスアクセス | E-01 (uberClassLoader参照) | ○ |
| C-16 | activePluginsで有効プラグイン管理 | E-01 | ○ |
| C-17 | failedPluginsでロード失敗プラグイン管理 | E-01 | ○ |
| C-18 | UpdateCenter経由でダウンロード | E-01 (import hudson.model.UpdateCenter) | ○ |
| C-19 | ADMINISTER権限が必要 | E-01 (Permission使用箇所) | ○ |
| C-20 | InitMilestone PLUGINS_LISTED等で段階的初期化 | E-01 (import static PLUGINS_LISTED等) | ○ |
| C-21 | API /pluginManager/api/json 提供 | E-01 (@ExportedBean) | ○ |
| C-22 | プラグインロード時間が数十秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス値（プラグインロード時間）の根拠となる計測データがない
  - 候補：パフォーマンステスト結果 / 起動ログの計測 / ベンチマークデータ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能概要、処理フロー、エラー処理はコードと整合
- 1: 中リスク - パフォーマンス値は推定値の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] PluginManager.javaの抽象メソッドとLocalPluginManagerの実装を対照確認
- [ ] 循環依存検出ロジックが正確に記述されているか確認
- [ ] プラグインロード時間の実測値と比較
- [ ] 画面機能マッピングとの整合性確認（画面No.37-42）
