---
generated_at: 2026-01-22 20:20:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-ログローテーション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/tasks/LogRotator.java` (63行目) - クラス定義
- E-02: `core/src/main/java/hudson/tasks/LogRotator.java` (54-61行目) - クラスJavadoc
- E-03: `core/src/main/java/hudson/tasks/LogRotator.java` (90-109行目) - フィールド定義
- E-04: `core/src/main/java/hudson/tasks/LogRotator.java` (115-116行目) - removeLastBuildフィールド
- E-05: `core/src/main/java/hudson/tasks/LogRotator.java` (117-121行目) - DataBoundConstructor
- E-06: `core/src/main/java/hudson/tasks/LogRotator.java` (156-226行目) - performメソッド
- E-07: `core/src/main/java/hudson/tasks/LogRotator.java` (228-246行目) - shouldKeepRunメソッド
- E-08: `core/src/main/java/hudson/tasks/LogRotator.java` (248-255行目) - tooNewメソッド
- E-09: `core/src/main/java/hudson/tasks/LogRotator.java` (302-308行目) - LRDescriptor
- E-10: `core/src/main/java/jenkins/model/BuildDiscarder.java` (29-40行目) - BuildDiscarder抽象クラス
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LogRotatorは古いビルド履歴の自動削除を管理する | E-02 | ○ |
| C-02 | LogRotatorはBuildDiscarderを継承している | E-01, E-10 | ○ |
| C-03 | daysToKeepでビルドを保持する日数を指定できる | E-03 (90-91行目) | ○ |
| C-04 | numToKeepで保持するビルド数を指定できる | E-03 (95-96行目) | ○ |
| C-05 | artifactDaysToKeepで成果物を保持する日数を指定できる | E-03 (98-102行目) | ○ |
| C-06 | artifactNumToKeepで成果物を保持するビルド数を指定できる | E-03 (104-109行目) | ○ |
| C-07 | removeLastBuildで最終成功・安定ビルドも削除可能 | E-04 | ○ |
| C-08 | performメソッドでログローテーションを実行 | E-06 | ○ |
| C-09 | isKeepLog()がtrueのビルドは削除しない | E-07 (229-231行目) | ○ |
| C-10 | 最終成功ビルドは削除しない（removeLastBuildがfalseの場合） | E-07 (233-235行目) | ○ |
| C-11 | 最終安定ビルドは削除しない（removeLastBuildがfalseの場合） | E-07 (237-239行目) | ○ |
| C-12 | ビルド中のビルドは削除しない | E-07 (241-243行目) | ○ |
| C-13 | 日付判定はtooNewメソッドで行う | E-08 | ○ |
| C-14 | 削除エラーは集約してCompositeIOExceptionとして送出 | E-06 (218-225行目) | ○ |
| C-15 | Stream APIを使用した効率的な処理 | E-06 (167-172行目) | ○ |
| C-16 | 「Log Rotation」という表示名を持つ | E-09 | ○ |
| C-17 | @Symbolアノテーションで「logRotator」が設定されている | E-09 (302行目) | ○ |
| C-18 | Jenkins 1.350以降で成果物削除オプションが追加 | E-02 (59行目) | ○ |
| C-19 | Jenkins 2.474以降でremoveLastBuildオプションが追加 | E-04 (114行目) | ○ |
| C-20 | ジョブ設定画面(No.12)とビルド削除確認(No.18)が関連画面 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主要機能説明がソースコードに基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] 4つの保持パラメータの相互作用が正しく説明されているか確認
- [ ] shouldKeepRunの判定優先順位が正確か確認
- [ ] 例外集約処理のフローが正確か確認
- [ ] 画面機能マッピングとの整合性を確認
