---
generated_at: 2026-01-22 20:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：23-SCMトリガー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **H構文導入バージョン（1.445）**：公式リリースノートでの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/triggers/SCMTrigger.java` (67行目) - クラス定義
- E-02: `core/src/main/java/hudson/triggers/SCMTrigger.java` (48-65行目) - クラスJavadoc
- E-03: `core/src/main/java/hudson/triggers/SCMTrigger.java` (88-90行目) - フィールド定義
- E-04: `core/src/main/java/hudson/triggers/SCMTrigger.java` (188-201行目) - run()メソッド
- E-05: `core/src/main/java/hudson/triggers/SCMTrigger.java` (294-350行目) - Runner内部クラス
- E-06: `core/src/main/java/hudson/triggers/SCMTrigger.java` (365-395行目) - DescriptorImpl
- E-07: `core/src/main/java/hudson/triggers/Trigger.java` (218-250行目) - Cron内部クラス
- E-08: `core/src/main/java/hudson/triggers/Trigger.java` (256-329行目) - checkTriggers()メソッド
- E-09: `core/src/main/java/hudson/triggers/Trigger.java` (338行目) - CRON_THRESHOLD定数
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SCMトリガーはSCMリポジトリをポーリングして変更を検知する | E-02 | ○ |
| C-02 | cronスケジュールに従って定期的にポーリングを実行 | E-04, E-07 | ○ |
| C-03 | specフィールドでcronスケジュールを保持 | E-03 | ○ |
| C-04 | ignorePostCommitHooksでpost-commitフックを無視可能 | E-03 | ○ |
| C-05 | run()メソッドでPollingSchedulerにスケジュール | E-04 | ○ |
| C-06 | Runner内部クラスでポーリング処理を実行 | E-05 | ○ |
| C-07 | PollingResultでポーリング結果を表現（BUILD_NOW/NO_CHANGES等） | E-05 | ○ |
| C-08 | synchronousPollingで依存関係順のポーリングが可能 | E-06, E-08 (260-287行目) | ○ |
| C-09 | maximumThreadsで同時ポーリング数を制限 | E-06 (370行目) | ○ |
| C-10 | 30秒以上かかるポーリングはSlowTriggerAdminMonitorで警告 | E-09 | ○ |
| C-11 | Cron.doRun()が毎分実行される | E-07 | ○ |
| C-12 | checkTriggers()で各トリガーをチェック | E-08 | ○ |
| C-13 | Hash関数でジョブごとにポーリング時間を分散 | E-07 (99行目 Trigger.java) | ○ |
| C-14 | ポーリングログはpolling.logに記録 | E-05 (332-350行目) | ○ |
| C-15 | SCMTriggerCauseでビルド原因を記録 | E-05 (315-320行目) | ○ |
| C-16 | ジョブ設定画面(No.12)とSCMポーリングログ(No.44)が関連画面 | E-10 | ○ |
| C-17 | デフォルトのmaximumThreadsは10 | E-06 (370行目) | ○ |
| C-18 | H構文はJenkins 1.445で導入 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- H構文の導入バージョン（1.445）の根拠
  - ソースコード内に明示的なバージョン記載なし
  - 候補：Jenkins公式リリースノート / CHANGELOGファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の説明はソースコードに基づいている
- 1: 中リスク - H構文導入バージョンは公式ドキュメントで確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ポーリングスケジュール処理のフローが正確か確認
- [ ] synchronousPollingモードの動作が正確か確認
- [ ] PollingResult列挙型の値が網羅されているか確認
- [ ] H構文導入バージョン（1.445）をリリースノートで確認
