---
generated_at: 2026-01-22 20:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-認証（SecurityRealm）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/security/SecurityRealm.java` (151行目) - クラス定義
- E-02: `core/src/main/java/hudson/security/SecurityRealm.java` (93-150行目) - クラスJavadoc
- E-03: `core/src/main/java/hudson/security/SecurityRealm.java` (173行目) - createSecurityComponents()
- E-04: `core/src/main/java/hudson/security/SecurityRealm.java` (604-609行目) - getSecurityComponents()
- E-05: `core/src/main/java/hudson/security/SecurityRealm.java` (626-684行目) - createFilter()
- E-06: `core/src/main/java/hudson/security/SecurityRealm.java` (686-694行目) - commonFilters()
- E-07: `core/src/main/java/hudson/security/SecurityRealm.java` (248-250行目) - getLoginUrl()
- E-08: `core/src/main/java/hudson/security/SecurityRealm.java` (346-384行目) - doLogout()
- E-09: `core/src/main/java/hudson/security/SecurityRealm.java` (285-312行目) - getPostLogOutUrl2()
- E-10: `core/src/main/java/hudson/security/SecurityRealm.java` (699行目) - NO_AUTHENTICATION
- E-11: `core/src/main/java/hudson/security/SecurityRealm.java` (822-916行目) - SecurityComponents
- E-12: `core/src/main/java/hudson/security/SecurityRealm.java` (942-948行目) - AUTHENTICATED_AUTHORITY2
- E-13: `core/src/main/java/hudson/security/SecurityRealm.java` (456-468行目) - loadUserByUsername2()
- E-14: `core/src/main/java/hudson/security/SecurityRealm.java` (497-518行目) - loadGroupByGroupname2()
- E-15: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SecurityRealmは外部ユーザーデータベースとJenkinsを接続する拡張ポイント | E-02 | ○ |
| C-02 | Describable、ExtensionPointを実装 | E-01 | ○ |
| C-03 | createSecurityComponents()が主要な抽象メソッド | E-03 | ○ |
| C-04 | SecurityComponentsでAuthenticationManager、UserDetailsService、RememberMeServicesを保持 | E-11 | ○ |
| C-05 | getSecurityComponents()でシングルトン取得 | E-04 | ○ |
| C-06 | createFilter()でフィルターチェーンを生成 | E-05 | ○ |
| C-07 | commonFilters()で共通フィルターを提供 | E-06 | ○ |
| C-08 | getLoginUrl()でログインページURLを返す | E-07 | ○ |
| C-09 | doLogout()でログアウト処理を実行 | E-08 | ○ |
| C-10 | getPostLogOutUrl2()でログアウト後のリダイレクト先を返す | E-09 | ○ |
| C-11 | NO_AUTHENTICATIONは認証なしモードのシングルトン | E-10 | ○ |
| C-12 | AUTHENTICATED_AUTHORITY2で認証済み権限を表現 | E-12 | ○ |
| C-13 | loadUserByUsername2()でユーザー詳細を取得 | E-13 | ○ |
| C-14 | loadGroupByGroupname2()でグループ詳細を取得 | E-14 | ○ |
| C-15 | SessionFixationProtectionStrategyでセッション固定保護 | E-05 (670-673行目) | ○ |
| C-16 | Remember-Me機能はTokenBasedRememberMeServices2で提供 | E-11 (910-914行目) | ○ |
| C-17 | セッション無効化とCookieクリアをログアウト時に実行 | E-08 (372-384行目) | ○ |
| C-18 | j_spring_security_checkが認証ゲートウェイURL | E-02 (229-234行目) | ○ |
| C-19 | ログイン画面(No.3)とセキュリティ設定(No.8)が関連画面 | E-15 | ○ |
| C-20 | UserMayOrMayNotExistException2でユーザー存在判定不可を表現 | E-14 (516行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主要機能説明がソースコードに基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] createSecurityComponents()の役割が正確か確認
- [ ] フィルターチェーンの構成順序が正確か確認
- [ ] ログアウト処理のフローが正確か確認
- [ ] セッション固定保護の実装が正確か確認
