---
generated_at: 2026-01-22 20:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-認可（AuthorizationStrategy）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/security/AuthorizationStrategy.java` (73行目) - クラス定義
- E-02: `core/src/main/java/hudson/security/AuthorizationStrategy.java` (52-71行目) - クラスJavadoc
- E-03: `core/src/main/java/hudson/security/AuthorizationStrategy.java` (80行目) - getRootACL()
- E-04: `core/src/main/java/hudson/security/AuthorizationStrategy.java` (91-93行目) - getACL(Job)
- E-05: `core/src/main/java/hudson/security/AuthorizationStrategy.java` (105-116行目) - getACL(View)
- E-06: `core/src/main/java/hudson/security/AuthorizationStrategy.java` (127-129行目) - getACL(AbstractItem)
- E-07: `core/src/main/java/hudson/security/AuthorizationStrategy.java` (140-142行目) - getACL(User)
- E-08: `core/src/main/java/hudson/security/AuthorizationStrategy.java` (153-155行目) - getACL(Computer)
- E-09: `core/src/main/java/hudson/security/AuthorizationStrategy.java` (182-184行目) - getACL(Cloud)
- E-10: `core/src/main/java/hudson/security/AuthorizationStrategy.java` (186-188行目) - getACL(Node)
- E-11: `core/src/main/java/hudson/security/AuthorizationStrategy.java` (204行目) - getGroups()
- E-12: `core/src/main/java/hudson/security/AuthorizationStrategy.java` (209-211行目) - all()
- E-13: `core/src/main/java/hudson/security/AuthorizationStrategy.java` (229行目) - UNSECURED
- E-14: `core/src/main/java/hudson/security/AuthorizationStrategy.java` (231-264行目) - Unsecured
- E-15: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AuthorizationStrategyはJenkinsの認可を制御する拡張ポイント | E-02 | ○ |
| C-02 | Describable、ExtensionPointを実装 | E-01 | ○ |
| C-03 | getRootACL()が主要な抽象メソッド | E-03 | ○ |
| C-04 | getGroups()も抽象メソッド | E-11 | ○ |
| C-05 | getACL(Job)はデフォルトでRootACLを返す | E-04 | ○ |
| C-06 | getACL(View)は特別な可視性判定ロジックを持つ | E-05 | ○ |
| C-07 | getACL(AbstractItem)はデフォルトでRootACLを返す | E-06 | ○ |
| C-08 | getACL(User)はデフォルトでRootACLを返す | E-07 | ○ |
| C-09 | getACL(Computer)はgetACL(Node)に委譲 | E-08 | ○ |
| C-10 | getACL(Cloud)はデフォルトでRootACLを返す | E-09 | ○ |
| C-11 | getACL(Node)はデフォルトでRootACLを返す | E-10 | ○ |
| C-12 | all()で全登録AuthorizationStrategyのDescriptorを取得 | E-12 | ○ |
| C-13 | UNSECUREDは認可なしモードのシングルトン | E-13 | ○ |
| C-14 | Unsecuredクラスは全アクセスを許可 | E-14 | ○ |
| C-15 | UNSECURED_ACLは常にtrueを返す | E-14 (249行目) | ○ |
| C-16 | セキュリティ設定画面(No.8)が関連画面 | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主要機能説明がソースコードに基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] getRootACL()とgetACL()の関係が正確か確認
- [ ] getACL(View)の可視性判定ロジックが正確か確認
- [ ] 各オブジェクトタイプ用getACL()のデフォルト実装が正確か確認
- [ ] Unsecuredクラスの動作が正確か確認
