---
generated_at: 2026-01-22 21:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-ユーザー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/model/User.java` (127行目) - クラス定義
- E-02: `core/src/main/java/hudson/model/User.java` (103-125行目) - クラスJavadoc
- E-03: `core/src/main/java/hudson/model/User.java` (182-184行目) - フィールド定義
- E-04: `core/src/main/java/hudson/model/User.java` (686-688行目) - getById()
- E-05: `core/src/main/java/hudson/model/User.java` (563-575行目) - get()
- E-06: `core/src/main/java/hudson/model/User.java` (646-648行目) - current()
- E-07: `core/src/main/java/hudson/model/User.java` (885-898行目) - save()
- E-08: `core/src/main/java/hudson/model/User.java` (202-216行目) - load()
- E-09: `core/src/main/java/hudson/model/User.java` (905-910行目) - delete()
- E-10: `core/src/main/java/hudson/model/User.java` (355-364行目) - addProperty()
- E-11: `core/src/main/java/hudson/model/User.java` (404-410行目) - getProperty()
- E-12: `core/src/main/java/hudson/model/User.java` (423-425行目) - impersonate2()
- E-13: `core/src/main/java/hudson/model/User.java` (450-471行目) - getUserDetailsForImpersonation2()
- E-14: `core/src/main/java/hudson/model/User.java` (177-178行目) - ILLEGAL_PERSISTED_USERNAMES
- E-15: `core/src/main/java/hudson/model/User.java` (959-966行目) - getACL()
- E-16: `core/src/main/java/hudson/model/User.java` (267-274行目) - idStrategy()
- E-17: `core/src/main/java/hudson/model/User.java` (846-854行目) - getUserFolderFor()
- E-18: `core/src/main/java/hudson/model/User.java` (1099-1200行目) - AllUsers
- E-19: `core/src/main/java/hudson/model/User.java` (1212-1282行目) - CanonicalIdResolver
- E-20: `core/src/main/java/hudson/model/User.java` (784-787行目) - getBuilds()
- E-21: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Userクラスはユーザーを表現するデータモデル | E-02 | ○ |
| C-02 | ExportedBeanを実装 | E-01 | ○ |
| C-03 | id、fullName、description、propertiesフィールドを持つ | E-03 | ○ |
| C-04 | getById()でIDによるユーザー取得 | E-04 | ○ |
| C-05 | get()でID/フルネームによるユーザー取得 | E-05 | ○ |
| C-06 | current()で現在ログインユーザー取得 | E-06 | ○ |
| C-07 | save()でユーザー設定を永続化 | E-07 | ○ |
| C-08 | load()でユーザー設定を読み込み | E-08 | ○ |
| C-09 | delete()でユーザーを削除 | E-09 | ○ |
| C-10 | addProperty()でプロパティを追加 | E-10 | ○ |
| C-11 | getProperty()でプロパティを取得 | E-11 | ○ |
| C-12 | impersonate2()でユーザー認証を偽装 | E-12 | ○ |
| C-13 | getUserDetailsForImpersonation2()で偽装用UserDetailsを取得 | E-13 | ○ |
| C-14 | anonymous、system、unknownは禁止ユーザー名 | E-14 | ○ |
| C-15 | 自分自身にフルアクセス権限を持つ | E-15 | ○ |
| C-16 | idStrategy()でIdStrategyを取得 | E-16 | ○ |
| C-17 | ユーザーディレクトリ名はハッシュ化 | E-17 | ○ |
| C-18 | AllUsersでシングルトン管理 | E-18 | ○ |
| C-19 | CanonicalIdResolverでユーザーID解決 | E-19 | ○ |
| C-20 | getBuilds()で関連ビルドを取得 | E-20 | ○ |
| C-21 | ConcurrentMapで高速ルックアップ | E-18 (1102行目) | ○ |
| C-22 | ユーザー一覧(No.5)、詳細(No.6)、設定(No.7)が関連画面 | E-21 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主要機能説明がソースコードに基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] getById()とget()の違いが正確か確認
- [ ] 禁止ユーザー名の処理が正確か確認
- [ ] AllUsersのシングルトン管理が正確か確認
- [ ] impersonate2()のフローが正確か確認
- [ ] ユーザーディレクトリのハッシュ計算が正確か確認
