---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：31-権限管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（数ミリ秒以内）**：具体的な数値の根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/security/Permission.java` - Permissionクラス全体
- E-02: `core/src/main/java/hudson/security/ACL.java` - ACLクラス全体
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（31行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Permissionはアクション毎の権限定義を表す | E-01 (40-48行目 Javadoc) | ○ |
| C-02 | PermissionGroupで権限を分類管理 | E-01 (58行目 group フィールド) | ○ |
| C-03 | ACLで権限チェックを実行 | E-02 (70-81行目 checkPermission) | ○ |
| C-04 | impliedByで権限の階層構造を管理 | E-01 (85-96行目 impliedBy Javadoc) | ○ |
| C-05 | SYSTEM認証は全権限をバイパス | E-02 (72-74行目, 134-136行目) | ○ |
| C-06 | 権限IDはowner.getName() + '.' + nameで生成 | E-01 (218-223行目 getId()) | ○ |
| C-07 | 権限名はJava識別子として有効であること | E-01 (145-146行目 JSONUtils.isJavaIdentifier) | ○ |
| C-08 | CopyOnWriteArrayListでスレッドセーフ | E-01 (280行目 ALL定義) | ○ |
| C-09 | AccessDeniedException3をスローする | E-02 (79行目 throw文) | ○ |
| C-10 | ANONYMOUSは明示的に権限制御対象 | E-02 (349-357行目 ANONYMOUS定義) | ○ |
| C-11 | EVERYONEは匿名含む全員を表す | E-02 (332-344行目 EVERYONE Javadoc) | ○ |
| C-12 | enabled=falseの権限はimpliedByを辿る | E-02 (76-78行目 whileループ) | ○ |
| C-13 | 関連画面：アクセス拒否（画面No.6） | E-04 (16行目) | ○ |
| C-14 | 関連画面：Who Am I（画面No.10） | E-04 (25行目) | ○ |
| C-15 | Jenkins.ADMINISTERに移行済み | E-01 (293-308行目 @Deprecated) | ○ |
| C-16 | fromId()で文字列から権限変換 | E-01 (240-253行目) | ○ |
| C-17 | PermissionScopeで適用範囲制御 | E-01 (115行目, 200-206行目) | ○ |
| C-18 | 権限チェックは数ミリ秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **パフォーマンス要件の根拠**：「数ミリ秒以内」という具体的な数値の根拠となるドキュメントやベンチマーク結果が見つからない
  - 候補：Jenkinsのパフォーマンステスト結果 / 設計要件ドキュメント / ベンチマーク実行

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 機能の説明は正確でソースコードと整合
- 0: 低リスク - API仕様の説明は正確
- 1: 中リスク - パフォーマンス要件の数値は推定値の可能性あり

## 6) レビュアーチェックリスト（最小）

- [ ] Permission.javaのimpliedBy動作が設計書の説明と一致するか確認
- [ ] ACL.checkPermissionの例外スロー条件が正確に記載されているか確認
- [ ] SYSTEM2認証のバイパス処理が漏れなく説明されているか確認
- [ ] パフォーマンス要件の数値を実際の要件と照合
