---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-APIトークン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/jenkins/security/ApiTokenProperty.java` - APIトークンプロパティ全体
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（32行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（106行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIトークンはUserPropertyとして管理される | E-01 (83行目 extends UserProperty) | ○ |
| C-02 | トークンはハッシュのみ保存、平文は保存しない | E-01 (110行目 tokenStore, 75-80行目 Javadoc) | ○ |
| C-03 | 生成時のみ平文を表示 | E-01 (588-594行目 tokenValue返却) | ○ |
| C-04 | ADMIN_CAN_GENERATE_NEW_TOKENSで管理者生成制御 | E-01 (98-107行目 設定定義) | ○ |
| C-05 | SHOW_LEGACY_TOKEN_TO_ADMINSでレガシー表示制御 | E-01 (87-95行目 設定定義) | ○ |
| C-06 | matchesPassword()でトークン検証 | E-01 (192-205行目) | ○ |
| C-07 | tokenStatsに使用統計を保存 | E-01 (113-117行目, 202行目) | ○ |
| C-08 | doGenerateNewToken()がPOSTエンドポイント | E-01 (569行目 @RequirePOST) | ○ |
| C-09 | トークン名が空の場合は日時から自動生成 | E-01 (576-580行目) | ○ |
| C-10 | revokeToken()でトークン無効化 | E-01 (458-468行目) | ○ |
| C-11 | revokeAllTokens()で全トークン無効化 | E-01 (442-446行目) | ○ |
| C-12 | canCurrentUserControlObject()で権限判定 | E-01 (215-231行目) | ○ |
| C-13 | API_KEY_SEEDはレガシー移行用 | E-01 (735-741行目 @Deprecated) | ○ |
| C-14 | 関連画面：ユーザーセキュリティ設定（画面No.46） | E-03 (106行目) | ○ |
| C-15 | User.save()で永続化 | E-01 (437行目, 446行目等) | ○ |
| C-16 | SYSTEM認証は常にトークン表示可能 | E-01 (226-227行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 機能の説明はソースコードと整合
- 0: 低リスク - セキュリティ設定の説明は正確

## 6) レビュアーチェックリスト（最小）

- [ ] doGenerateNewTokenの権限チェックが正しく説明されているか確認
- [ ] トークンのハッシュ化処理がApiTokenStoreで行われていることを確認
- [ ] レガシートークンと新方式トークンの違いが明確に説明されているか確認
- [ ] SECURITY-49, SECURITY-200の対策が適切に実装されているか確認
