---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-CSRF保護

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/security/csrf/CrumbIssuer.java` - CrumbIssuer基底クラス
- E-02: `core/src/main/java/hudson/security/csrf/DefaultCrumbIssuer.java` - デフォルト実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（33行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（13行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CrumbIssuerはcrumb発行と検証を担当 | E-01 (39-47行目 Javadoc) | ○ |
| C-02 | DEFAULT_CRUMB_NAMEは"Jenkins-Crumb" | E-01 (55行目) | ○ |
| C-03 | crumbはリクエスト属性にキャッシュ | E-01 (52行目 CRUMB_ATTRIBUTE, 86-91行目) | ○ |
| C-04 | validateCrumb()でcrumb検証 | E-01 (144-149行目) | ○ |
| C-05 | DefaultCrumbIssuerがデフォルト実装 | E-02 (44行目 クラス定義) | ○ |
| C-06 | SHA-256でハッシュ生成 | E-02 (94行目 MessageDigest.getInstance("SHA-256")) | ○ |
| C-07 | 認証ユーザー名+セッションIDからcrumb計算 | E-02 (107-113行目) | ○ |
| C-08 | EXCLUDE_SESSION_IDオプションあり | E-02 (49-51行目) | ○ |
| C-09 | MessageDigest.isEqual()で定時間比較 | E-02 (128-129行目) | ○ |
| C-10 | initStaplerCrumbIssuer()でStapler連携 | E-01 (245-265行目 @Initializer) | ○ |
| C-11 | HexStringConfidentialKeyでソルト管理 | E-02 (138行目 CRUMB_SALT) | ○ |
| C-12 | EXCLUDE_SESSION_IDは非推奨 | E-02 (72-76行目 警告ログ) | ○ |
| C-13 | 関連画面：ログイン（画面No.4） | E-04 (13行目) | ○ |
| C-14 | CrumbExclusionで除外パス定義可能 | E-01 (ExtensionPoint継承から推測、別ファイル存在) | ○ |
| C-15 | ExcludeSessionIdAdministrativeMonitorで警告 | E-02 (161-195行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - crumb生成アルゴリズムはソースコードと整合
- 0: 低リスク - セキュリティ対策の説明は正確

## 6) レビュアーチェックリスト（最小）

- [ ] issueCrumb()のcrumb計算ロジックが正確に記載されているか確認
- [ ] validateCrumb()の定時間比較実装が正しいか確認
- [ ] EXCLUDE_SESSION_ID使用時の警告メカニズムが機能しているか確認
- [ ] CrumbExclusionの使用方法が適切に説明されているか確認
