---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-リストビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/model/ListView.java` - ListViewクラス全体
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（36行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ListViewはView継承、DirectlyModifiableView実装 | E-01 (82行目) | ○ |
| C-02 | jobNamesはTreeSet、case-insensitive | E-01 (88行目) | ○ |
| C-03 | includeRegexで正規表現フィルタ | E-01 (97行目) | ○ |
| C-04 | recurseでフォルダ再帰検索 | E-01 (102行目) | ○ |
| C-05 | getItems()でフィルタリングされたジョブ取得 | E-01 (203-272行目) | ○ |
| C-06 | add()でジョブ追加 | E-01 (299-304行目) | ○ |
| C-07 | remove()でジョブ削除 | E-01 (312-319行目) | ○ |
| C-08 | doAddJobToView()はREST API | E-01 (395行目 @RequirePOST) | ○ |
| C-09 | ViewJobFilterでフィルタリング | E-01 (260-266行目) | ○ |
| C-10 | LinkedHashSetで重複除去 | E-01 (269行目) | ○ |
| C-11 | Listener内部クラスでジョブ追従 | E-01 (563-652行目) | ○ |
| C-12 | PatternSyntaxException処理 | E-01 (143-149行目 readResolve) | ○ |
| C-13 | @Symbol("list")でJenkinsfile対応 | E-01 (528行目) | ○ |
| C-14 | statusFilterは@Deprecated | E-01 (115行目, 340-345行目) | ○ |
| C-15 | doCheckIncludeRegex()で正規表現検証 | E-01 (539-549行目) | ○ |
| C-16 | getAllItems()はrecurse=true時に使用 | E-01 (229行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - getItems()の処理フローはソースコードと整合
- 0: 低リスク - フィルタリングロジックの説明は正確

## 6) レビュアーチェックリスト（最小）

- [ ] getItems()の処理順序が正確に記載されているか確認
- [ ] recurse=true時のパフォーマンス影響が明記されているか確認
- [ ] Listenerによるジョブ追従処理が正確か確認
- [ ] ViewJobFilterの適用順序が正確か確認
