---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-ダッシュボード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/model/AllView.java` - AllViewクラス全体
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（38行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（3行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AllViewはView継承 | E-01 (54行目) | ○ |
| C-02 | DEFAULT_VIEW_NAME = "all" | E-01 (63行目) | ○ |
| C-03 | isEditable()はfalse固定 | E-01 (82行目 return false) | ○ |
| C-04 | contains()は常にtrue | E-01 (87行目 return true) | ○ |
| C-05 | getDisplayName()でローカライズ判定 | E-01 (91-93行目) | ○ |
| C-06 | getItems()は全ジョブを返却 | E-01 (106-108行目) | ○ |
| C-07 | getPostConstructLandingPage()は空文字 | E-01 (112行目 return "") | ○ |
| C-08 | @Symbol("all")でJenkinsfile対応 | E-01 (195行目) | ○ |
| C-09 | isApplicableIn()で既存AllViewチェック | E-01 (198-205行目) | ○ |
| C-10 | migrateLegacyPrimaryAllViewLocalizedName()で移行 | E-01 (156-193行目) | ○ |
| C-11 | システムプロパティで移行無効化可能 | E-01 (162行目) | ○ |
| C-12 | since 1.269で追加 | E-01 (53行目 Javadoc) | ○ |
| C-13 | submit()は空実装 | E-01 (116-126行目 noop) | ○ |
| C-14 | 関連画面：ダッシュボード（画面No.1） | E-03 (3行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - シンプルな実装のため説明は正確

## 6) レビュアーチェックリスト（最小）

- [ ] getItems()の全ジョブ返却が正確か確認
- [ ] JENKINS-38606移行ロジックが正確か確認
- [ ] isApplicableIn()のViewGroup制限が正確か確認
