---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 23
  claims_with_evidence: 22
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：4-ジョブ（Job）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：22 / 23、根拠なし：1
- 優先レビュー（高）
  1. **ジョブロード時間（数千ジョブで数十秒）**：具体的な計測値の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/model/Job.java` - Jobクラス
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JobはRunを生成する実行可能エンティティ | E-01 (143-153行目 JavaDoc) | ○ |
| C-02 | Job<JobT, RunT>のジェネリクス定義 | E-01 (154-155行目) | ○ |
| C-03 | nextBuildNumberはtransient volatile int | E-01 (167行目) | ○ |
| C-04 | holdOffBuildUntilSaveでビルド保留 | E-01 (173行目) | ○ |
| C-05 | holdOffBuildUntilUserSaveで最終保持 | E-01 (180行目) | ○ |
| C-06 | logRotatorはBuildDiscarderPropertyに置き換え | E-01 (183-184行目 @Deprecated) | ○ |
| C-07 | cachedBuildHealthReportsでキャッシュ | E-01 (191-192行目) | ○ |
| C-08 | propertiesはCopyOnWriteList | E-01 (200行目) | ○ |
| C-09 | save()でholdOffBuildUntilSave更新 | E-01 (207-210行目) | ○ |
| C-10 | onLoad()でnextBuildNumber読み込み | E-01 (213-251行目) | ○ |
| C-11 | legacyIdsファイルの削除ロジック | E-01 (220-226行目) | ○ |
| C-12 | onCopiedFrom()でnextBuildNumber=1リセット | E-01 (254-261行目) | ○ |
| C-13 | LastItemListenerでコピー後のフラグ管理 | E-01 (263-277行目) | ○ |
| C-14 | getNextBuildNumberFile()でファイルパス取得 | E-01 (279-281行目) | ○ |
| C-15 | isHoldOffBuildUntilSave()でsynchronized | E-01 (283-285行目) | ○ |
| C-16 | saveNextBuildNumber()で0を1に修正 | E-01 (287-292行目) | ○ |
| C-17 | isInQueue()はデフォルトfalse | E-01 (294-297行目) | ○ |
| C-18 | 関連画面（ダッシュボード、ジョブ詳細等）と整合 | E-03 | ○ |
| C-19 | ExtensionPoint実装 | E-01 (155行目) | ○ |
| C-20 | StaplerOverridable実装 | E-01 (155行目) | ○ |
| C-21 | ModelObjectWithChildren実装 | E-01 (155行目) | ○ |
| C-22 | HasWidgets実装 | E-01 (155行目) | ○ |
| C-23 | ジョブロードが数千ジョブで数十秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ジョブロードのパフォーマンス計測値
  - 候補：起動ログの計測 / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造、ビジネスロジック、メソッド定義はコードと整合
- 1: 中リスク - パフォーマンス値は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] Job.javaのジェネリクス定義が正確に説明されているか確認
- [ ] ビルド番号管理ロジックの正確性を確認
- [ ] holdOffBuildUntilSave関連の動作フローを確認
- [ ] 画面機能マッピングとの整合性確認
