---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-ビルドコマンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/cli/BuildCommand.java` - BuildCommandクラス全体
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（40行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BuildCommandはCLICommand継承 | E-01 (68行目 extends CLICommand) | ○ |
| C-02 | @Extensionで登録 | E-01 (67行目) | ○ |
| C-03 | JOB引数は@Argument必須 | E-01 (74-75行目) | ○ |
| C-04 | -fオプションでfollow | E-01 (77-78行目) | ○ |
| C-05 | -sオプションでsync | E-01 (80-81行目) | ○ |
| C-06 | -wオプションでwait | E-01 (83-84行目) | ○ |
| C-07 | -cオプションでSCMチェック | E-01 (86-87行目) | ○ |
| C-08 | -pオプションでパラメータ指定 | E-01 (89-90行目) | ○ |
| C-09 | -vオプションでコンソール出力 | E-01 (92-93行目) | ○ |
| C-10 | Item.BUILD権限チェック | E-01 (102行目) | ○ |
| C-11 | パラメータ定義取得とParametersAction生成 | E-01 (104-143行目) | ○ |
| C-12 | EditDistance.findNearestで類似名サジェスト | E-01 (117行目) | ○ |
| C-13 | SCMDecisionHandler.firstShouldPollVeto | E-01 (150行目) | ○ |
| C-14 | scheduleBuild2でビルド登録 | E-01 (167行目) | ○ |
| C-15 | waitForStart()で開始待機 | E-01 (174行目) | ○ |
| C-16 | writeWholeLogToでコンソール出力 | E-01 (188行目) | ○ |
| C-17 | Result.ordinalを返却 | E-01 (204行目) | ○ |
| C-18 | CLICauseはUserIdCause継承 | E-01 (240行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - オプションの説明はソースコードと整合
- 0: 低リスク - 処理フローの説明は正確

## 6) レビュアーチェックリスト（最小）

- [ ] run()の処理フローが正確に記載されているか確認
- [ ] パラメータ処理の詳細が正確か確認
- [ ] -s/-fオプションの中断動作の違いが正確か確認
- [ ] 終了コードの計算が正確か確認
