---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：41-ジョブ管理コマンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（1秒以内）**：ソースコードからは導出できない数値
  2. **SSH経由の実行方法**：CLIコマンドソースからは確認できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/cli/CreateJobCommand.java`
- E-02: `core/src/main/java/hudson/cli/DeleteJobCommand.java`
- E-03: `core/src/main/java/hudson/cli/GetJobCommand.java`
- E-04: `core/src/main/java/hudson/cli/CopyJobCommand.java`
- E-05: `core/src/main/java/hudson/cli/ListJobsCommand.java`
- E-06: `core/src/main/java/hudson/cli/ReloadJobCommand.java`
- E-07: `core/src/main/java/hudson/cli/CLICommand.java`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | create-jobは標準入力からXMLを読み込んでジョブを作成する | E-01 (76行目: `ig.createProjectFromXML(name, stdin)`) | ○ |
| C-02 | create-jobで同名ジョブが存在する場合はIllegalStateExceptionがスローされる | E-01 (54-56行目) | ○ |
| C-03 | create-jobでフォルダ階層を「/」で指定できる | E-01 (59-73行目) | ○ |
| C-04 | create-jobでJenkins.checkGoodName()によるバリデーションが行われる | E-01 (75行目) | ○ |
| C-05 | delete-jobは複数ジョブを一度に削除できる | E-02 (45-46行目: `multiValued = true`) | ○ |
| C-06 | delete-jobはジョブ存在チェックを行う | E-02 (68-70行目) | ○ |
| C-07 | delete-jobはItem.DELETE権限をチェックする | E-02 (72行目) | ○ |
| C-08 | delete-jobで複数ジョブ処理時にエラーがあっても継続処理する | E-02 (74-83行目) | ○ |
| C-09 | delete-jobでエラー発生時はAbortExceptionをスローする | E-02 (86-88行目) | ○ |
| C-10 | get-jobはジョブのXML設定を標準出力に出力する | E-03 (46行目: `job.writeConfigDotXml(stdout)`) | ○ |
| C-11 | copy-jobはコピー元とコピー先のジョブ名を引数に取る | E-04 (47-52行目) | ○ |
| C-12 | copy-jobでコピー先に同名ジョブが存在する場合はエラー | E-04 (58-60行目) | ○ |
| C-13 | copy-jobはig.copy()でジョブをコピーする | E-04 (79行目) | ○ |
| C-14 | list-jobsはビュー名またはアイテムグループ名でフィルタ可能 | E-05 (57-76行目) | ○ |
| C-15 | list-jobsで名前未指定時は全ジョブを表示 | E-05 (79-81行目) | ○ |
| C-16 | reload-jobは複数ジョブを一度に再読み込みできる | E-06 (47行目: `multiValued = true`) | ○ |
| C-17 | reload-jobはItem.CONFIGURE権限をチェックする | E-06 (85行目) | ○ |
| C-18 | reload-jobはdoReload()を呼び出す | E-06 (86行目) | ○ |
| C-19 | 関連画面としてCLI操作画面（No.59）がある | E-09 (127-131行目) | ○ |
| C-20 | CreateJobCommandは@Extensionアノテーションで登録される | E-01 (39行目) | ○ |
| C-21 | DeleteJobCommandは@Extensionアノテーションで登録される | E-02 (41行目) | ○ |
| C-22 | 機能一覧でジョブ管理コマンドはNo.41である | E-08 (42行目) | ○ |
| C-23 | 機能一覧の説明はCreateJobCommandとDeleteJobCommandを参照している | E-08 (42行目) | ○ |
| C-24 | 単一ジョブの作成/削除は1秒以内で完了する | **根拠なし** | △ |
| C-25 | SSH経由で`ssh -l user -p port jenkins command`で実行可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値根拠
  - 候補：ベンチマークテスト結果 / 運用実績データ / 公式ドキュメント
- SSH経由の実行方法の詳細
  - 候補：Jenkins公式ドキュメント / SSHDプラグインのソースコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- パフォーマンス要件は実測値ではないため、本番環境で検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] CreateJobCommandの入力パラメータ記載が正確か確認
- [ ] DeleteJobCommandのエラーハンドリング記載が正確か確認
- [ ] 関連画面マッピングが正しいか確認
- [ ] パフォーマンス要件の妥当性を確認（必要に応じて実測）
- [ ] SSH実行方法の記載を公式ドキュメントと照合
