---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：42-ノード管理コマンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（1秒以内）**：ソースコードからは導出できない数値
  2. **get-node/update-nodeコマンドの詳細**：ソースコード未読み込みのため詳細確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/cli/CreateNodeCommand.java`
- E-02: `core/src/main/java/hudson/cli/DeleteNodeCommand.java`
- E-03: `core/src/main/java/hudson/cli/ConnectNodeCommand.java`
- E-04: `core/src/main/java/hudson/cli/DisconnectNodeCommand.java`
- E-05: `core/src/main/java/hudson/cli/OnlineNodeCommand.java`
- E-06: `core/src/main/java/hudson/cli/OfflineNodeCommand.java`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | create-nodeはComputer.CREATE権限をチェックする | E-01 (53行目) | ○ |
| C-02 | create-nodeはJenkins.XSTREAM2.fromXML()でXMLをパースする | E-01 (55行目) | ○ |
| C-03 | create-nodeでコマンドライン引数でノード名を上書きできる | E-01 (57-61行目) | ○ |
| C-04 | create-nodeで同名ノード存在時はIllegalStateExceptionがスローされる | E-01 (63-64行目) | ○ |
| C-05 | delete-nodeは複数ノードを一度に削除できる | E-02 (44行目: `multiValued = true`) | ○ |
| C-06 | delete-nodeはjenkins.getNode()でノードを取得する | E-02 (65行目) | ○ |
| C-07 | delete-nodeはnode.toComputer().doDoDelete()で削除を実行する | E-02 (71行目) | ○ |
| C-08 | connect-nodeは-fオプションで強制再接続できる | E-03 (48-49行目) | ○ |
| C-09 | connect-nodeはComputer.resolveForCLI()でComputerを取得する | E-03 (65行目) | ○ |
| C-10 | connect-nodeはcomputer.cliConnect(force)で接続を実行する | E-03 (66行目) | ○ |
| C-11 | disconnect-nodeは-mオプションで切断理由を指定できる | E-04 (49-50行目) | ○ |
| C-12 | disconnect-nodeは存在しないノードに対して類似名を提案する | E-04 (78-81行目) | ○ |
| C-13 | disconnect-nodeはEditDistance.findNearest()で類似名を検索する | E-04 (78行目) | ○ |
| C-14 | disconnect-nodeはcomputer.cliDisconnect(cause)で切断を実行する | E-04 (84行目) | ○ |
| C-15 | online-nodeはComputer.resolveForCLI()でComputerを取得する | E-05 (57行目) | ○ |
| C-16 | online-nodeはcomputer.cliOnline()でオンライン化する | E-05 (58行目) | ○ |
| C-17 | offline-nodeは-mオプションでオフライン理由を指定できる | E-06 (49-50行目) | ○ |
| C-18 | offline-nodeは存在しないノードに対して類似名を提案する | E-06 (68-74行目) | ○ |
| C-19 | offline-nodeはcomputer.cliOffline(cause)でオフライン化する | E-06 (76行目) | ○ |
| C-20 | 機能一覧でノード管理コマンドはNo.42である | E-07 (43行目) | ○ |
| C-21 | 機能一覧の説明はConnectNodeCommandとDisconnectNodeCommandを参照している | E-07 (43行目) | ○ |
| C-22 | 複数ノード処理時にエラーがあっても継続処理してAbortExceptionをスローする | E-03, E-04, E-05, E-06 (各ファイルのエラーハンドリング部分) | ○ |
| C-23 | 単一ノードの操作は1秒以内で完了する | **根拠なし** | △ |
| C-24 | get-node/update-nodeコマンドが存在する | **根拠なし（ソース未読み込み）** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値根拠
  - 候補：ベンチマークテスト結果 / 運用実績データ / 公式ドキュメント
- GetNodeCommand.java、UpdateNodeCommand.javaの詳細
  - 候補：ソースコードの読み込み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- パフォーマンス要件は実測値ではないため、本番環境で検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] CreateNodeCommandの権限チェック記載が正確か確認
- [ ] 複数ノード処理のエラーハンドリング記載が正確か確認
- [ ] 類似名提案機能の動作を確認
- [ ] パフォーマンス要件の妥当性を確認（必要に応じて実測）
- [ ] GetNodeCommand/UpdateNodeCommandの存在と仕様を確認
