---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：43-プラグイン管理コマンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：ソースコードからは導出できない数値
  2. **プラグイン署名検証**：実装詳細の確認必要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/cli/InstallPluginCommand.java`
- E-02: `core/src/main/java/hudson/cli/EnablePluginCommand.java`
- E-03: `core/src/main/java/hudson/cli/DisablePluginCommand.java`
- E-04: `core/src/main/java/hudson/cli/ListPluginsCommand.java`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | install-pluginはJenkins.ADMINISTER権限をチェックする | E-01 (86行目) | ○ |
| C-02 | install-pluginは「=」で標準入力からインストールできる | E-01 (94-102行目) | ○ |
| C-03 | install-pluginはURLからダウンロードしてインストールできる | E-01 (106-115行目) | ○ |
| C-04 | install-pluginはプラグイン名でアップデートセンターから検索できる | E-01 (121-132行目) | ○ |
| C-05 | install-pluginは-restartオプションで再起動できる | E-01 (77-78行目, 166-167行目) | ○ |
| C-06 | install-pluginは-deployオプションで動的ロードできる | E-01 (80-81行目, 99-101行目) | ○ |
| C-07 | install-pluginはプラグイン名:バージョン形式でバージョン指定できる | E-01 (121-132行目) | ○ |
| C-08 | enable-pluginはJenkins.ADMINISTER権限をチェックする | E-02 (60行目) | ○ |
| C-09 | enable-pluginは依存プラグインを自動的に有効化する | E-02 (87-98行目) | ○ |
| C-10 | enable-pluginは-restartオプションで再起動できる | E-02 (49-50行目, 66-68行目) | ○ |
| C-11 | disable-pluginはJenkins.ADMINISTER権限をチェックする | E-03 (77-78行目) | ○ |
| C-12 | disable-pluginは-strategyオプションで依存戦略を指定できる | E-03 (49-53行目) | ○ |
| C-13 | disable-pluginの戦略はnone/mandatory/allの3種類 | E-03 (49-52行目, 82-93行目) | ○ |
| C-14 | disable-pluginはリターンコード16で依存関係エラーを返す | E-03 (66-67行目) | ○ |
| C-15 | disable-pluginはリターンコード17でプラグイン不存在エラーを返す | E-03 (67行目) | ○ |
| C-16 | list-pluginsはJenkins.ADMINISTER権限をチェックする | E-04 (53行目) | ○ |
| C-17 | list-pluginsは特定プラグイン名を指定して表示できる | E-04 (47-48行目, 57-65行目) | ○ |
| C-18 | list-pluginsは更新可能バージョンを併記する | E-04 (90-96行目) | ○ |
| C-19 | 機能一覧でプラグイン管理コマンドはNo.43である | E-05 (44行目) | ○ |
| C-20 | プラグインファイルは.jpi拡張子で保存される | E-01 (187行目) | ○ |
| C-21 | パフォーマンス要件（一覧表示1秒以内） | **根拠なし** | △ |
| C-22 | プラグインの署名検証が推奨される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値根拠
  - 候補：ベンチマークテスト結果 / 運用実績データ
- プラグイン署名検証の詳細
  - 候補：PluginManager.javaの署名検証実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- セキュリティに関する署名検証の記載は実装確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] InstallPluginCommandのソース種別判定が正確か確認
- [ ] DisablePluginCommandの戦略パターン記載が正確か確認
- [ ] リターンコードの定義が正確か確認
- [ ] プラグイン署名検証の実装状況を確認
