---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：44-Groovyコンソール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（起動1秒以内）**：ソースコードからは導出できない数値

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/cli/GroovyCommand.java`
- E-02: `core/src/main/java/hudson/cli/GroovyshCommand.java`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | groovyコマンドはJenkins.ADMINISTER権限をチェックする | E-01 (66行目) | ○ |
| C-02 | groovyコマンドは「=」で標準入力からスクリプトを読み込む | E-01 (89-90行目) | ○ |
| C-03 | groovyコマンドはout/stdin/stdout/stderrをBindingに設定する | E-01 (70-74行目) | ○ |
| C-04 | groovyコマンドはPluginManager.uberClassLoaderを使用する | E-01 (76行目) | ○ |
| C-05 | groovyコマンドはScriptListener.fireScriptExecution()で通知する | E-01 (78行目) | ○ |
| C-06 | groovyshコマンドはJenkins.ADMINISTER権限をチェックする | E-02 (72行目) | ○ |
| C-07 | groovyshコマンドはUnsupportedTerminalを使用する | E-02 (75-76行目) | ○ |
| C-08 | groovyshコマンドはjenkins/hudsonオブジェクトをバインドする | E-02 (108-109行目) | ○ |
| C-09 | groovyshコマンドはhudson.model.*をデフォルトインポートする | E-02 (133行目) | ○ |
| C-10 | groovyshコマンドは入力をScriptListenerで記録する | E-02 (147行目) | ○ |
| C-11 | 機能一覧でGroovyコンソールはNo.44である | E-03 (45行目) | ○ |
| C-12 | 関連画面としてスクリプトコンソール（No.60）がある | E-04 (132-133行目) | ○ |
| C-13 | スクリプトコンソールの主機能はGroovyスクリプトの実行 | E-04 (132行目) | ○ |
| C-14 | groovyコマンドはARGUMENTSパラメータでスクリプト引数を渡せる | E-01 (60-61行目, 79行目) | ○ |
| C-15 | groovyshコマンドはARGSパラメータを受け取る | E-02 (67行目) | ○ |
| C-16 | groovyコマンドでスクリプト未指定時はCmdLineExceptionがスローされる | E-01 (87-88行目) | ○ |
| C-17 | groovyshコマンドはLoggingGroovyShクラスを使用する | E-02 (132行目, 137-149行目) | ○ |
| C-18 | スクリプト起動オーバーヘッドは1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値根拠
  - 候補：ベンチマークテスト結果 / 運用実績データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- セキュリティ関連の記載は適切（管理者権限必須、監査ログ）

## 6) レビュアーチェックリスト（最小）
- [ ] GroovyCommand/GroovyshCommandの権限チェック記載が正確か確認
- [ ] Binding設定の項目が正確か確認
- [ ] ScriptListener連携の記載が正確か確認
- [ ] パフォーマンス要件の妥当性を確認（必要に応じて実測）
