---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：46-管理画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（1秒以内）**：ソースコードからは導出できない数値

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/model/ManagementLink.java`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ManagementLinkはExtensionPointを実装する | E-01 (58行目) | ○ |
| C-02 | getIconFileName()でアイコンを取得する | E-01 (69-70行目) | ○ |
| C-03 | アイコンがnullの場合はリンクを非表示 | E-01 (65-66行目 JavaDoc) | ○ |
| C-04 | getDescription()で説明文を取得する | E-01 (79-81行目) | ○ |
| C-05 | getUrlName()でリンクURLを取得する | E-01 (90-91行目) | ○ |
| C-06 | getRequiresConfirmation()で確認ダイアログ要否を取得する | E-01 (100-102行目) | ○ |
| C-07 | all()で全ManagementLinkを取得する | E-01 (115-117行目) | ○ |
| C-08 | getRequiredPermission()で必要権限を取得する | E-01 (126-128行目) | ○ |
| C-09 | デフォルトでJenkins.ADMINISTER権限が必要 | E-01 (127行目) | ○ |
| C-10 | getRequiresPOST()でPOSTメソッド要否を取得する | E-01 (136-138行目) | ○ |
| C-11 | getCategory()でカテゴリを取得する | E-01 (158-165行目) | ○ |
| C-12 | CategoryにはCONFIGURATION/SECURITY/STATUS/TROUBLESHOOTING/TOOLS/MISCがある | E-01 (172-205行目) | ○ |
| C-13 | getBadge()でバッジを取得する | E-01 (224-226行目) | ○ |
| C-14 | 機能一覧で管理画面はNo.46である | E-02 (47行目) | ○ |
| C-15 | 関連画面としてJenkinsの管理（No.48）がある | E-03 (主画面のマッピングより推定) | ○ |
| C-16 | プラグインはManagementLinkを継承して管理リンクを追加可能 | E-01 (JavaDoc) | ○ |
| C-17 | アイコンはSVG形式を推奨 | E-01 (62-63行目 JavaDoc) | ○ |
| C-18 | 管理画面表示は1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値根拠
  - 候補：ベンチマークテスト結果 / 運用実績データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ManagementLinkの各メソッドの説明が正確か確認
- [ ] カテゴリ定義が正確か確認
- [ ] 権限チェックの記載が正確か確認
- [ ] パフォーマンス要件の妥当性を確認
