---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：47-管理モニター

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（2秒以内）**：ソースコードからは導出できない数値

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/model/AdministrativeMonitor.java`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AdministrativeMonitorはExtensionPointとStaplerProxyを実装する | E-01 (90行目) | ○ |
| C-02 | idフィールドでモニターを一意に識別する | E-01 (98行目) | ○ |
| C-03 | getUrl()で「administrativeMonitor/{id}」形式のURLを返す | E-01 (111-113行目) | ○ |
| C-04 | disable(boolean)でモニターの無効化状態を設定する | E-01 (128-138行目) | ○ |
| C-05 | 無効化状態はJenkins.disabledAdministrativeMonitorsに保存される | E-01 (131-136行目) | ○ |
| C-06 | isEnabled()で無効化されていないことを確認する | E-01 (147-149行目) | ○ |
| C-07 | isActivated()は抽象メソッドで各実装で問題検知を行う | E-01 (159行目) | ○ |
| C-08 | isSecurity()でセキュリティ関連フラグを返す（デフォルトfalse） | E-01 (173-175行目) | ○ |
| C-09 | doDisable()はPOSTで無効化を実行する | E-01 (180-184行目) | ○ |
| C-10 | doDisable()はJenkins.ADMINISTER権限をチェックする | E-01 (182行目) | ○ |
| C-11 | getRequiredPermission()で表示に必要な権限を返す（デフォルトADMINISTER） | E-01 (208-211行目) | ○ |
| C-12 | checkRequiredPermission()で権限チェックを実行する | E-01 (223-225行目) | ○ |
| C-13 | hasRequiredPermission()で権限有無を確認する | E-01 (237-239行目) | ○ |
| C-14 | all()で全AdministrativeMonitorを取得する | E-01 (265-267行目) | ○ |
| C-15 | 機能一覧で管理モニターはNo.47である | E-02 (48行目) | ○ |
| C-16 | 関連画面としてJenkinsの管理（No.48）がある | E-03 (主画面のマッピングより推定) | ○ |
| C-17 | message.jellyで警告メッセージを表示する | E-01 (65-72行目 JavaDoc) | ○ |
| C-18 | プラグインはAdministrativeMonitorを継承してモニターを追加可能 | E-01 (JavaDoc) | ○ |
| C-19 | getTarget()でStaplerProxy用のアクセス制御を実装 | E-01 (255-260行目) | ○ |
| C-20 | 全モニターの一括チェックは2秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値根拠
  - 候補：ベンチマークテスト結果 / 運用実績データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] AdministrativeMonitorの各メソッドの説明が正確か確認
- [ ] 権限チェックの記載が正確か確認
- [ ] 主要モニターの一覧が正確か確認
- [ ] パフォーマンス要件の妥当性を確認
