---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：48-ロード統計

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（1秒以内）**：ソースコードからは導出できない数値

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/model/LoadStatistics.java`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | definedExecutorsは全エグゼキュータ数を保持する | E-01 (79-80行目) | ○ |
| C-02 | onlineExecutorsはオンラインエグゼキュータ数を保持する | E-01 (86-87行目) | ○ |
| C-03 | connectingExecutorsは接続中エグゼキュータ数を保持する | E-01 (93-94行目) | ○ |
| C-04 | busyExecutorsはビジー状態のエグゼキュータ数を保持する | E-01 (99-100行目) | ○ |
| C-05 | idleExecutorsはアイドルエグゼキュータ数を保持する | E-01 (107-108行目) | ○ |
| C-06 | availableExecutorsは利用可能エグゼキュータ数を保持する | E-01 (114-115行目) | ○ |
| C-07 | queueLengthはキューの長さを保持する | E-01 (129-130行目) | ○ |
| C-08 | LoadStatisticsUpdaterはPeriodicWorkを継承する | E-01 (351-352行目) | ○ |
| C-09 | デフォルトのCLOCKは10秒（10000ミリ秒） | E-01 (346行目) | ○ |
| C-10 | DECAYのデフォルト値は0.9 | E-01 (341行目) | ○ |
| C-11 | getRecurrencePeriod()はCLOCKを返す | E-01 (354-356行目) | ○ |
| C-12 | doRun()で各ラベルのloadStatisticsを更新する | E-01 (359-366行目) | ○ |
| C-13 | unlabeledLoadとoverallLoadも更新する | E-01 (369-371行目) | ○ |
| C-14 | createChart()でJFreeChartを生成する | E-01 (189-226行目) | ○ |
| C-15 | computeSnapshot()でスナップショットを計算する | E-01 (304-334行目) | ○ |
| C-16 | updateCounts()で時系列データを更新する | E-01 (267-275行目) | ○ |
| C-17 | LoadStatisticsSnapshotはスナップショットデータを保持する | E-01 (392-625行目) | ○ |
| C-18 | Builderパターンでスナップショットを構築する | E-01 (564-619行目) | ○ |
| C-19 | 機能一覧でロード統計はNo.48である | E-02 (49行目) | ○ |
| C-20 | 関連画面としてロード統計（No.51）がある | E-03 (マッピングより推定) | ○ |
| C-21 | DECAY/CLOCKはシステムプロパティで変更可能 | E-01 (341行目, 346行目) | ○ |
| C-22 | グラフ生成は1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値根拠
  - 候補：ベンチマークテスト結果 / 運用実績データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 各統計メトリクスの説明が正確か確認
- [ ] DECAY/CLOCKの計算説明が正確か確認
- [ ] LoadStatisticsUpdaterの動作が正確か確認
- [ ] パフォーマンス要件の妥当性を確認
