---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-フリースタイルプロジェクト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/model/FreeStyleProject.java` - FreeStyleProjectクラス
- E-02: `core/src/main/java/hudson/model/Build.java` - Buildクラス（参照）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FreeStyleProjectはProject<FreeStyleProject, FreeStyleBuild>を継承 | E-01 (43行目) | ○ |
| C-02 | TopLevelItemを実装 | E-01 (43行目) | ○ |
| C-03 | 非推奨コンストラクタ（Jenkins指定） | E-01 (46-51行目 @Deprecated) | ○ |
| C-04 | ItemGroup指定のコンストラクタ | E-01 (53-55行目) | ○ |
| C-05 | getBuildClass()はFreeStyleBuild.class返却 | E-01 (57-60行目) | ○ |
| C-06 | getDescriptor()でDescriptorImpl取得 | E-01 (62-65行目) | ○ |
| C-07 | DESCRIPTORは後方互換用の非推奨static | E-01 (74-77行目 @Deprecated) | ○ |
| C-08 | @Extension(ordinal = 1000) | E-01 (79行目) | ○ |
| C-09 | @Symbol({"freeStyle", "freeStyleJob"}) | E-01 (79行目) | ○ |
| C-10 | AbstractProjectDescriptor継承 | E-01 (80行目) | ○ |
| C-11 | getDisplayName()でMessages.FreeStyleProject_DisplayName() | E-01 (86-89行目) | ○ |
| C-12 | newInstance()でFreeStyleProject生成 | E-01 (93-95行目) | ○ |
| C-13 | getDescription()でMessages.FreeStyleProject_Description() | E-01 (98-100行目) | ○ |
| C-14 | getCategoryId()でStandaloneProjectsCategory.ID | E-01 (103-105行目) | ○ |
| C-15 | getIconFilePathPattern()でfreestyleproject.png | E-01 (108-110行目) | ○ |
| C-16 | getIconClassName()でsymbol-freestyle-project | E-01 (113-115行目) | ○ |
| C-17 | IconSet.iconsにアイコン登録 | E-01 (117-122行目 static block) | ○ |
| C-18 | 関連画面（新規ジョブ作成等）と整合 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目がソースコードと整合

## 6) レビュアーチェックリスト（最小）
- [ ] FreeStyleProject.javaの全行がドキュメントでカバーされているか確認
- [ ] 親クラス（Project, AbstractProject）との責務分担が明確か確認
- [ ] アイコン登録の正確性を確認
