---
generated_at: 2026-01-22 20:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：51-拡張機構

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件のO(1)キャッシュヒット**：実測データなし
  2. **プラグイン署名検証の推奨**：セキュリティ実装の詳細未確認
  3. **動的ロード対応の挙動**：実際の動作検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/Extension.java` 全体
- E-02: `core/src/main/java/hudson/ExtensionPoint.java` 全体
- E-03: `core/src/main/java/hudson/ExtensionList.java` 全体
- E-04: `core/src/main/java/hudson/ExtensionFinder.java` 1-200行目
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 38行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @Extensionアノテーションがクラス、メソッド、フィールドに適用可能 | E-01 (73行目: @Target({TYPE, FIELD, METHOD})) | ○ |
| C-02 | ordinal属性でソート順を制御可能 | E-01 (79-85行目) | ○ |
| C-03 | optional属性でエラー無視が可能（非推奨） | E-01 (87-94行目) | ○ |
| C-04 | dynamicLoadable属性で動的ロード対応を指定 | E-01 (97-116行目) | ○ |
| C-05 | ExtensionPointはマーカーインターフェース | E-02 (全体、メソッド定義なし) | ○ |
| C-06 | ExtensionList.lookup()がエントリーポイント | E-03 (436-438行目) | ○ |
| C-07 | Jenkins未起動時は空リストを返却 | E-03 (437-438行目) | ○ |
| C-08 | ensureLoaded()で遅延ロードを実行 | E-03 (300-314行目) | ○ |
| C-09 | ordinal降順でソート | E-03 (407-411行目, Collections.sort) | ○ |
| C-10 | CopyOnWriteパターンで同期 | E-03 (77-78行目, @CopyOnWrite) | ○ |
| C-11 | ExtensionListListenerで変更通知 | E-03 (363-371行目) | ○ |
| C-12 | refresh()で動的更新が可能 | E-03 (329-360行目) | ○ |
| C-13 | lookupSingleton()で単一インスタンス取得 | E-03 (452-461行目) | ○ |
| C-14 | ExtensionFinderが拡張発見を担当 | E-04 (87行目, abstract class定義) | ○ |
| C-15 | SezPozでインデックス生成 | E-01 (37行目, 71行目: @Indexable) | ○ |
| C-16 | Guice統合がオプションで利用可能 | E-04 (190-200行目) | ○ |
| C-17 | 関連画面No.38でプラグイン拡張情報表示 | E-05 (38行目) | ○ |
| C-18 | パフォーマンスがO(1)でキャッシュヒット | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の「O(1)キャッシュヒット」は実測データがなく、コードの構造から推測
  - 候補：パフォーマンステスト結果 / ベンチマーク / 設計ドキュメント
- セキュリティに関する「プラグイン署名検証」の詳細な実装確認が未完了
  - 候補：PluginManager.java / UpdateCenter.java / セキュリティ設計書

## 5) リスクフラグ（レビュー観点）
- 0: 機能説明は低リスク（ソースコードと一致）
- 1: パフォーマンス要件は中リスク（実測未確認）
- 0: 処理フローは低リスク（コードで確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] Extension.javaのアノテーション属性が正しく記載されているか確認
- [ ] ExtensionList.lookup()の実際の挙動をコードで確認
- [ ] 動的プラグインロード時のrefresh()の動作確認
- [ ] パフォーマンス要件が妥当かどうか検討
- [ ] セキュリティ考慮事項の追加検討が必要か判断
