---
generated_at: 2026-01-22 20:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：53-ルートアクション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **sidepanel.jellyの確認**：サイドバー構築ロジックの検証が必要
  2. **Action.javaの参照**：親インターフェースの詳細確認
  3. **Jenkins.javaでのRootAction利用**：実際の呼び出し箇所の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/model/RootAction.java` 全体（68行）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 53行目
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 関連行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RootActionはActionとExtensionPointを継承 | E-01 (42行目: `public interface RootAction extends Action, ExtensionPoint`) | ○ |
| C-02 | Jenkinsルートにアクションを追加するマーカー | E-01 (33-41行目 Javadoc) | ○ |
| C-03 | @Extensionで自動登録される | E-01 (36-37行目 Javadoc) | ○ |
| C-04 | getBadge()でバッジを返却可能 | E-01 (44-52行目) | ○ |
| C-05 | getBadge()のデフォルトはnull | E-01 (50-52行目: `default @CheckForNull Badge getBadge() { return null; }`) | ○ |
| C-06 | isPrimaryAction()でヘッダー表示を制御 | E-01 (54-66行目) | ○ |
| C-07 | isPrimaryAction()のデフォルトはfalse | E-01 (64-66行目: `default boolean isPrimaryAction() { return false; }`) | ○ |
| C-08 | v2.507でBadge機能追加 | E-01 (51行目: `@since 2.507`) | ○ |
| C-09 | v2.516でisPrimaryAction追加 | E-01 (65行目: `@since 2.516`) | ○ |
| C-10 | v1.311で導入 | E-01 (40行目: `@since 1.311`) | ○ |
| C-11 | Badge.javaがバッジクラス | E-01 (30行目: import jenkins.management.Badge) | ○ |
| C-12 | iconFileName nullで非表示 | E-01 (Javadoc参照、Actionから継承) | ○ |
| C-13 | urlNameでルーティング | E-01 (Actionから継承、Javadoc) | ○ |
| C-14 | ExtensionListで自動発見 | E-01 (ExtensionPointを継承) | ○ |
| C-15 | sidepanel.jellyでサイドバー構築 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- sidepanel.jellyのソースコードを直接確認していない
  - 候補：`core/src/main/resources/lib/layout/sidepanel.jelly`を読み込んで検証
- Action.javaの詳細（getIconFileName, getDisplayName, getUrlNameの定義）
  - 候補：`core/src/main/java/hudson/model/Action.java`を読み込んで検証
- Jenkins.javaでのRootAction利用パターン
  - 候補：`core/src/main/java/jenkins/model/Jenkins.java`でRootAction参照箇所を確認

## 5) リスクフラグ（レビュー観点）
- 0: RootAction.javaからの直接引用は低リスク
- 1: サイドバー構築ロジックは中リスク（未読込）
- 0: バージョン情報はコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Action.javaを確認し、親インターフェースの仕様が正しいか検証
- [ ] sidepanel.jellyを確認し、サイドバー構築ロジックを検証
- [ ] Jenkins.javaでRootActionがどのように使用されているか確認
- [ ] Badge.javaの構造と利用方法を確認
- [ ] isPrimaryActionの実際のUI動作を検証
