---
generated_at: 2026-01-22 20:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：57-ブールパラメータ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **BooleanParameterValue.javaの確認**：値クラスの詳細確認が推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/model/BooleanParameterDefinition.java` 全体（142行）
- E-02: `core/src/main/java/hudson/model/SimpleParameterDefinition.java` 全体（50行）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 12, 20行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SimpleParameterDefinitionを継承 | E-01 (43行目: `extends SimpleParameterDefinition`) | ○ |
| C-02 | defaultValueフィールドはboolean型 | E-01 (44行目: `private boolean defaultValue`) | ○ |
| C-03 | @DataBoundConstructorでname必須 | E-01 (49-52行目) | ○ |
| C-04 | 3引数コンストラクタあり | E-01 (54-58行目) | ○ |
| C-05 | isDefaultValue()でデフォルト値取得 | E-01 (69-71行目) | ○ |
| C-06 | setDefaultValue()でデフォルト値設定 | E-01 (76-79行目) | ○ |
| C-07 | createValue(req, jo)でbindJSON使用 | E-01 (82-86行目) | ○ |
| C-08 | createValue(String)でBoolean.parseBoolean使用 | E-01 (89-91行目: `Boolean.parseBoolean(value)`) | ○ |
| C-09 | getDefaultParameterValue()でBooleanParameterValue生成 | E-01 (94-96行目) | ○ |
| C-10 | hashCode()でname,description,defaultValueハッシュ | E-01 (98-104行目) | ○ |
| C-11 | equals()でフィールド比較 | E-01 (106-123行目) | ○ |
| C-12 | @Symbol("booleanParam")でシンボル定義 | E-01 (127行目) | ○ |
| C-13 | コメントでJava予約語回避を説明 | E-01 (125-126行目コメント) | ○ |
| C-14 | getHelpFile()で"/help/parameter/boolean.html" | E-01 (135-138行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主要な主張について根拠が確認できた
- 追加で確認が推奨される項目：
  - BooleanParameterValue.javaの構造
  - config.jelly/index.jellyのUI実装

## 5) リスクフラグ（レビュー観点）
- 0: すべての主張がソースコードから直接確認（低リスク）
- 0: Boolean.parseBoolean()の動作は標準Java API（低リスク）
- 0: @Symbolの回避理由はコードコメントで明示（低リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] BooleanParameterValue.javaで値クラスの実装を確認
- [ ] config.jellyでデフォルト値設定UIを確認
- [ ] index.jellyでチェックボックス表示を確認
