---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：6-ビルド（Build）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **RunListener通知の詳細タイミング**：一部リスナーの呼び出し順序が不明確

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/model/Run.java` - Runクラス
- E-02: `core/src/main/java/hudson/model/Build.java` - Buildクラス
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BuildはAbstractBuild継承 | E-02 (86-87行目) | ○ |
| C-02 | Run<JobT, RunT>のジェネリクス | E-01 (169-170行目) | ○ |
| C-03 | QUEUE_ID_UNKNOWN = -1 | E-01 (176行目) | ○ |
| C-04 | number (ビルド番号) フィールド | E-01 (187行目) | ○ |
| C-05 | queueIdフィールド | E-01 (192行目) | ○ |
| C-06 | timestampフィールド | E-01 (207行目) | ○ |
| C-07 | startTimeフィールド | E-01 (216行目) | ○ |
| C-08 | resultフィールド（volatile） | E-01 (222行目) | ○ |
| C-09 | descriptionフィールド | E-01 (230-231行目) | ○ |
| C-10 | displayNameフィールド | E-01 (238行目) | ○ |
| C-11 | State enum（NOT_STARTED〜COMPLETED） | E-01 (245-268行目) | ○ |
| C-12 | durationフィールド | E-01 (273行目) | ○ |
| C-13 | charsetフィールド | E-01 (283行目) | ○ |
| C-14 | keepLogフィールド | E-01 (288行目) | ○ |
| C-15 | runnerフィールド | E-01 (294行目) | ○ |
| C-16 | artifactManagerフィールド | E-01 (300行目) | ○ |
| C-17 | Build.run()でcreateRunner()呼び出し | E-02 (113-115行目) | ○ |
| C-18 | BuildExecution内部クラス | E-02 (136行目) | ○ |
| C-19 | doRun()でpreBuild実行 | E-02 (144-147行目) | ○ |
| C-20 | BuildWrapperのsetUp実行 | E-02 (157-162行目) | ○ |
| C-21 | build()でBuilder実行 | E-02 (164行目) | ○ |
| C-22 | post2()でPublisher実行 | E-02 (178-183行目) | ○ |
| C-23 | 関連画面（ビルド詳細、コンソール等）と整合 | E-04 | ○ |
| C-24 | RunListener通知の詳細タイミング | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- RunListenerの各メソッド（fireStarted, fireCompleted, fireFinalized）の呼び出しタイミング詳細
  - 候補：RunListener.java / Run.javaの該当メソッド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造、フィールド定義はコードと整合
- 1: 中リスク - リスナー通知の順序は別途確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Run.javaのState enum定義が正確か確認
- [ ] Build.BuildExecutionの処理フローが正確か確認
- [ ] RunListener通知タイミングを確認
- [ ] 画面機能マッピングとの整合性確認
