---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：64-フォームバリデーション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **クライアント側 JavaScript**：サーバー側コードのみ確認、JS は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/util/FormValidation.java` - FormValidation クラスのソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Kind 列挙型（OK/WARNING/ERROR） | E-01 (126-140行目) | ○ |
| C-02 | FormValidation は IOException を継承 | E-01 (120行目) | ○ |
| C-03 | error() ファクトリメソッド | E-01 (149-151行目) | ○ |
| C-04 | warning() ファクトリメソッド | E-01 (153-155行目) | ○ |
| C-05 | ok() ファクトリメソッド | E-01 (157-159, 166-168行目) | ○ |
| C-06 | validateExecutable() | E-01 (330-373行目) | ○ |
| C-07 | validateNonNegativeInteger() | E-01 (378-386行目) | ○ |
| C-08 | validatePositiveInteger() | E-01 (415-423行目) | ○ |
| C-09 | validateRequired() | E-01 (428-432行目) | ○ |
| C-10 | validateBase64() | E-01 (445-461行目) | ○ |
| C-11 | aggregate() による集約 | E-01 (229-246行目) | ○ |
| C-12 | URLCheck クラス | E-01 (469-584行目) | ○ |
| C-13 | CheckMethod クラス | E-01 (623-725行目) | ○ |
| C-14 | CSP ヘッダー設定 | E-01 (121, 614-616行目) | ○ |
| C-15 | Util.escape() によるエスケープ | E-01 (150, 154, 158行目) | ○ |
| C-16 | Jenkins.ADMINISTER 権限チェック | E-01 (344行目) | ○ |
| C-17 | クライアント側 JavaScript の動作 | **根拠なし（JS 未確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- クライアント側 JavaScript：FormValidation のサーバー側実装は確認したが、クライアント側の AJAX 呼び出し実装は未確認
  - 候補：`war/src/main/js/` 配下の JavaScript ファイル / Jelly テンプレート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サーバー側実装の説明は正確
- 1: 中リスク - クライアント側の動作説明は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] validateExecutable() の権限チェックが正確か
- [ ] aggregate() の集約ロジックが正確か
- [ ] CSP ヘッダーの設定内容が正確か
- [ ] URLCheck の動作説明が正確か
