---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：65-REST API

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **Stapler/ModelBuilder の詳細**：外部ライブラリの詳細は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/model/Api.java` - Api クラスのソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Api は AbstractModelObject を継承 | E-01 (81行目) | ○ |
| C-02 | bean プロパティで公開対象保持 | E-01 (85-88行目) | ○ |
| C-03 | doXml() メソッド | E-01 (104-211行目) | ○ |
| C-04 | doJson() メソッド | E-01 (231-263行目) | ○ |
| C-05 | doPython() メソッド | E-01 (268-296行目) | ○ |
| C-06 | setHeaders() でセキュリティヘッダー設定 | E-01 (308-315行目) | ○ |
| C-07 | X-Jenkins ヘッダー | E-01 (309行目) | ○ |
| C-08 | X-Content-Type-Options: nosniff | E-01 (312行目) | ○ |
| C-09 | X-Frame-Options: deny | E-01 (314行目) | ○ |
| C-10 | permit() による JSONP 制御 | E-01 (257, 298-305行目) | ○ |
| C-11 | XPath による XML フィルタリング | E-01 (145-183行目) | ○ |
| C-12 | wrapper パラメータ | E-01 (152-172行目) | ○ |
| C-13 | wrapper 名の検証 | E-01 (156-161行目) | ○ |
| C-14 | 404 エラー（XPath 結果なし） | E-01 (173-176行目) | ○ |
| C-15 | 500 エラー（複数結果で wrapper なし） | E-01 (177-180行目) | ○ |
| C-16 | Stapler/ModelBuilder の詳細 | **外部ライブラリ** | △ |

## 4) 不足情報（Unknown / Missing）
- Stapler/ModelBuilder：Jenkins 外部の Stapler ライブラリの詳細は Api.java からは確認できない
  - 候補：Stapler ライブラリのソースコード / ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - セキュリティヘッダーの説明は正確
- 0: 低リスク - XPath 処理の説明は正確

## 6) レビュアーチェックリスト（最小）
- [ ] setHeaders() のヘッダー設定が最新のセキュリティベストプラクティスに準拠しているか
- [ ] permit() の SecureRequester 連携が正確か
- [ ] XPath 処理のエラーケースが網羅されているか
- [ ] FilteredFunctionContext の制限内容が正確か
