---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：66-RSSフィード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **Jelly テンプレートの詳細**：テンプレートファイルは未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/model/RSS.java` - RSS クラスのソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RSS は static メソッドのみのユーティリティクラス | E-01 (46行目) | ○ |
| C-02 | forwardToRss() メソッド | E-01 (61-78行目) | ○ |
| C-03 | flavor パラメータでフィード形式選択 | E-01 (67-68行目) | ○ |
| C-04 | デフォルトは atom 形式 | E-01 (68行目) | ○ |
| C-05 | パストラバーサル対策 | E-01 (69行目) | ○ |
| C-06 | Atom の Content-Type | E-01 (72行目) | ○ |
| C-07 | RSS の Content-Type | E-01 (74行目) | ○ |
| C-08 | Jelly テンプレートへの転送 | E-01 (77行目) | ○ |
| C-09 | rss() ヘルパーメソッド | E-01 (103-136行目) | ○ |
| C-10 | Run.FEED_ADAPTER のデフォルト使用 | E-01 (134行目) | ○ |
| C-11 | リクエスト属性設定 | E-01 (62-65行目) | ○ |
| C-12 | Jelly テンプレートの詳細 | **テンプレート未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- Jelly テンプレート：atom.jelly, rss2.jelly の実際の内容は未確認
  - 候補：`core/src/main/resources/hudson/atom.jelly`, `core/src/main/resources/hudson/rss2.jelly`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - RSS.java の実装説明は正確
- 1: 中リスク - Jelly テンプレートの詳細は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] forwardToRss() の処理フローが正確か
- [ ] flavor パラメータの検証が十分か
- [ ] Content-Type の設定が標準に準拠しているか
- [ ] Jelly テンプレートが存在し、正しく動作するか
