---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：67-WebSocket

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **WebSocketSession の詳細**：基底クラスの詳細は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `websocket/spi/src/main/java/jenkins/websocket/Provider.java` - Provider インターフェース
- E-02: `core/src/main/java/jenkins/websocket/WebSockets.java` - WebSockets クラス
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Provider インターフェースの構造 | E-01 (40-78行目) | ○ |
| C-02 | Provider.handle() メソッド | E-01 (46行目) | ○ |
| C-03 | Listener インターフェース | E-01 (48-62行目) | ○ |
| C-04 | Handler インターフェース | E-01 (64-76行目) | ○ |
| C-05 | ServiceLoader による Provider 検索 | E-02 (54-64行目) | ○ |
| C-06 | upgrade() メソッド | E-02 (68-75行目) | ○ |
| C-07 | upgradeResponse() メソッド | E-02 (81-142行目) | ○ |
| C-08 | Provider 不在時の 404 | E-02 (82-84行目) | ○ |
| C-09 | onWebSocketConnect() コールバック | E-02 (91-95行目) | ○ |
| C-10 | onWebSocketClose() コールバック | E-02 (103-106行目) | ○ |
| C-11 | ClosedChannelException の処理 | E-02 (110-111行目) | ○ |
| C-12 | isSupported() メソッド | E-02 (144-146行目) | ○ |
| C-13 | Ping/Pong 処理 | E-02 (93, 104行目) | ○ |
| C-14 | WebSocketSession の詳細 | **未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- WebSocketSession：基底クラスの詳細実装は未確認
  - 候補：`core/src/main/java/jenkins/websocket/WebSocketSession.java`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Provider/WebSockets の説明は正確
- 1: 中リスク - WebSocketSession の詳細は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] Provider インターフェースの説明が正確か
- [ ] upgradeResponse() のエラーハンドリングが正確か
- [ ] Listener コールバックの順序が正確か
- [ ] Ping/Pong 処理の詳細が正確か
