---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：68-ラベル管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **LabelExpression 派生クラスの詳細**：派生クラスは未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/model/Label.java` - Label クラスのソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Label は抽象クラス | E-01 (92行目) | ○ |
| C-02 | name フィールド | E-01 (97行目) | ○ |
| C-03 | nodes キャッシュ | E-01 (98行目) | ○ |
| C-04 | clouds キャッシュ | E-01 (99行目) | ○ |
| C-05 | loadStatistics フィールド | E-01 (104行目) | ○ |
| C-06 | nodeProvisioner フィールド | E-01 (106行目) | ○ |
| C-07 | parseExpression() メソッド | E-01 (621-629行目) | ○ |
| C-08 | matches() 抽象メソッド | E-01 (172行目) | ○ |
| C-09 | matches(Collection) メソッド | E-01 (178-188行目) | ○ |
| C-10 | matches(Node) メソッド | E-01 (190-192行目) | ○ |
| C-11 | getNodes() メソッド | E-01 (207-220行目) | ○ |
| C-12 | getClouds() メソッド | E-01 (252-263行目) | ○ |
| C-13 | getTotalExecutors() メソッド | E-01 (303-311行目) | ○ |
| C-14 | reset() メソッド | E-01 (435-439行目) | ○ |
| C-15 | ConverterImpl | E-01 (556-575行目) | ○ |
| C-16 | LabelExpression 派生クラスの詳細 | **未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- LabelExpression 派生クラス：And, Or, Not, Iff, Implies, Paren の詳細実装は未確認
  - 候補：`core/src/main/java/hudson/model/labels/LabelExpression.java`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Label クラスの説明は正確
- 1: 中リスク - 派生クラスの詳細は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] parseExpression() の ANTLR パース処理が正確か
- [ ] matches() のマッチングロジックが正確か
- [ ] キャッシュのリセットタイミングが正確か
- [ ] LabelExpression 派生クラスの動作が正確か
