---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：69-負荷分散

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **MappingWorksheet の詳細**：ワークシートの詳細実装は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/model/LoadBalancer.java` - LoadBalancer クラスのソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LoadBalancer は抽象クラス | E-01 (54行目) | ○ |
| C-02 | ExtensionPoint を実装 | E-01 (54行目) | ○ |
| C-03 | map() 抽象メソッド | E-01 (76-77行目) | ○ |
| C-04 | CONSISTENT_HASH 定数 | E-01 (82-140行目) | ○ |
| C-05 | ConsistentHash 構築 | E-01 (87-100行目) | ○ |
| C-06 | 重み = ec.size() * 100 | E-01 (95行目) | ○ |
| C-07 | assignGreedily() メソッド | E-01 (113-139行目) | ○ |
| C-08 | アフィニティキー取得 | E-01 (117-122行目) | ○ |
| C-09 | RuntimeException 時のフォールバック | E-01 (119-122行目) | ○ |
| C-10 | isPartiallyValid() チェック | E-01 (130行目) | ○ |
| C-11 | sanitize() メソッド | E-01 (156-178行目) | ○ |
| C-12 | シャットダウンチェック | E-01 (161-163行目) | ○ |
| C-13 | DEFAULT は CONSISTENT_HASH のエイリアス | E-01 (149行目) | ○ |
| C-14 | MappingWorksheet の詳細 | **未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- MappingWorksheet：ワークシートの詳細実装と works、applicableExecutorChunks の動作は未確認
  - 候補：`core/src/main/java/hudson/model/queue/MappingWorksheet.java`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - LoadBalancer の説明は正確
- 1: 中リスク - MappingWorksheet との連携詳細は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] CONSISTENT_HASH の ConsistentHash 構築が正確か
- [ ] assignGreedily() の再帰ロジックが正確か
- [ ] sanitize() のシャットダウンチェックが正確か
- [ ] アフィニティキーの取得ロジックが正確か
