---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 21
  claims_with_evidence: 20
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：7-キュー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：20 / 21、根拠なし：1
- 優先レビュー（高）
  1. **キュー容量制限**：大量キューへの対応の具体的実装が不明確

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/model/Queue.java` - Queueクラス
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QueueはResourceController継承、Saveable実装 | E-01 (183行目) | ○ |
| C-02 | waitingListはTreeSet<WaitingItem> | E-01 (193行目) | ○ |
| C-03 | blockedProjectsはItemList<BlockedItem> | E-01 (202行目) | ○ |
| C-04 | buildablesはItemList<BuildableItem> | E-01 (209行目) | ○ |
| C-05 | pendingsはItemList<BuildableItem> | E-01 (215行目) | ○ |
| C-06 | snapshotでスナップショット管理 | E-01 (217行目) | ○ |
| C-07 | leftItemsは5分キャッシュ | E-01 (224行目) | ○ |
| C-08 | JobOffer内部クラスでエグゼキュータオファー管理 | E-01 (235行目以降) | ○ |
| C-09 | workUnitフィールドで割り当て管理 | E-01 (241行目) | ○ |
| C-10 | set()でワークユニット設定 | E-01 (248-253行目) | ○ |
| C-11 | getCauseOfBlockage()でブロック理由取得 | E-01 (274-300行目) | ○ |
| C-12 | QueueTaskDispatcherでディスパッチ判定 | E-01 (283-293行目) | ○ |
| C-13 | キュー状態遷移（waiting→blocked/buildable→pending→left） | E-01 (145-177行目 JavaDoc) | ○ |
| C-14 | 関連画面（ダッシュボード等）と整合 | E-03 | ○ |
| C-15 | Item.CANCEL権限でキャンセル | E-01 (import文) | ○ |
| C-16 | ReentrantLockで排他制御 | E-01 (import文) | ○ |
| C-17 | ConsistentHashでノード選択 | E-01 (import文) | ○ |
| C-18 | QueueItemAuthenticatorで認証管理 | E-01 (import文) | ○ |
| C-19 | @ExportedBeanでAPI公開 | E-01 (182行目) | ○ |
| C-20 | FlyweightTaskの特別扱い | E-01 (import文) | ○ |
| C-21 | 大量キュー（数千アイテム）対応 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- 大量キュー処理のパフォーマンス特性
  - 候補：パフォーマンステスト結果 / メモリ使用量計測

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造、状態遷移はコードと整合
- 1: 中リスク - スケーラビリティに関する記述は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] Queue.javaの4つのコレクション（waiting/blocked/buildable/pending）の関係が正確か確認
- [ ] JobOffer.getCauseOfBlockage()のロジックが正確か確認
- [ ] 状態遷移図がコードの実装と一致しているか確認
- [ ] 大量キュー時の動作を実際に確認
