---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：9-コントローラーノード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **ノード名が空文字列である根拠**：実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/jenkins/model/Jenkins.java` - Jenkinsクラス
- E-02: `core/src/main/java/hudson/model/Node.java` - Nodeクラス
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JenkinsはAbstractCIBase継承 | E-01 (356行目) | ○ |
| C-02 | numExecutorsフィールド（デフォルト2） | E-01 (400行目) | ○ |
| C-03 | modeフィールド（デフォルトNORMAL） | E-01 (405行目) | ○ |
| C-04 | labelフィールド | E-01 (667行目) | ○ |
| C-05 | nodeNameAndSelfLabelOverride | E-01 (669行目) | ○ |
| C-06 | nodeRenameMigrationNeeded | E-01 (872行目) | ○ |
| C-07 | nodePropertiesリスト | E-01 (741行目) | ○ |
| C-08 | globalNodePropertiesリスト | E-01 (746行目) | ○ |
| C-09 | 2016年の名称変更（master→controller） | E-01 (コメント/JavaDoc参照) | ○ |
| C-10 | ADMINISTER権限でシステム設定変更 | E-01 (Permission使用) | ○ |
| C-11 | config.xmlで設定永続化 | E-01 (XmlFile使用) | ○ |
| C-12 | JenkinsがNodeインターフェース実装（間接的） | E-01, E-02 | ○ |
| C-13 | 関連画面（システム設定等）と整合 | E-04 | ○ |
| C-14 | numExecutors=0でビルド実行無効化 | E-01 (ロジック) | ○ |
| C-15 | EXCLUSIVEモードでラベル指定ジョブのみ | E-01 (Mode enum) | ○ |
| C-16 | ビルトインノードの名前は空文字列 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- ビルトインノードの名前が空文字列である実装箇所
  - 候補：getNodeName()の実装 / AbstractCIBase

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要フィールド、設定項目はコードと整合
- 1: 中リスク - ノード名の扱いは別途確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Jenkins.javaのNode関連メソッドが正確に記述されているか確認
- [ ] AbstractCIBaseとの関係が正確か確認
- [ ] ビルトインノードの名前の実装を確認
- [ ] 画面機能マッピングとの整合性確認
