---
generated_at: 2026-01-22 19:15:00
metrics:
  claims_total: 78
  claims_with_evidence: 78
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：78 / 78、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠があるため、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/hudson/model/View/index.jelly`
- E-02: `core/src/main/resources/hudson/model/View/newJob.jelly`
- E-03: `core/src/main/resources/jenkins/model/Jenkins/newView.jelly`
- E-04: `core/src/main/resources/jenkins/model/Jenkins/login.jelly`
- E-05: `core/src/main/resources/jenkins/model/Jenkins/loginError.jelly`
- E-06: `core/src/main/resources/jenkins/model/Jenkins/accessDenied.jelly`
- E-07: `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/signup.jelly`
- E-08: `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/addUser.jelly`
- E-09: `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/firstUser.jelly`
- E-10: `core/src/main/resources/hudson/security/WhoAmI/index.jelly`
- E-11: `core/src/main/resources/hudson/model/Job/index.jelly`
- E-12: `core/src/main/resources/hudson/model/Job/configure.jelly`
- E-13: `core/src/main/resources/hudson/model/Job/buildTimeTrend.jelly`
- E-14: `core/src/main/resources/hudson/model/Run/index.jelly`
- E-15: `core/src/main/resources/hudson/model/Run/console.jelly`
- E-16: `core/src/main/resources/hudson/model/Run/consoleFull.jelly`
- E-17: `core/src/main/resources/hudson/model/Run/configure.jelly`
- E-18: `core/src/main/resources/hudson/model/Run/confirmDelete.jelly`
- E-19: `core/src/main/resources/hudson/model/Run/artifacts-index.jelly`
- E-20: `core/src/main/resources/hudson/model/ParametersDefinitionProperty/index.jelly`
- E-21: `core/src/main/resources/hudson/model/ComputerSet/index.jelly`
- E-22: `core/src/main/resources/hudson/model/Computer/index.jelly`
- E-23: `core/src/main/resources/hudson/model/Computer/configure.jelly`
- E-24: `core/src/main/resources/hudson/model/Computer/load-statistics.jelly`
- E-25: `core/src/main/resources/hudson/model/Computer/markOffline.jelly`
- E-26: `core/src/main/resources/jenkins/agents/CloudSet/index.jelly`
- E-27: `core/src/main/resources/hudson/slaves/Cloud/index.jelly`
- E-28: `core/src/main/resources/hudson/model/ManageJenkinsAction/index.jelly`
- E-29: `core/src/main/resources/jenkins/model/Jenkins/configure.jelly`
- E-30: `core/src/main/resources/jenkins/model/Jenkins/configureExecutors.jelly`
- E-31: `core/src/main/resources/jenkins/model/Jenkins/systemInfo.jelly`
- E-32: `core/src/main/resources/jenkins/model/Jenkins/load-statistics.jelly`
- E-33: `core/src/main/resources/jenkins/model/Jenkins/threadDump.jelly`
- E-34: `core/src/main/resources/jenkins/model/Jenkins/_restart.jelly`
- E-35: `core/src/main/resources/jenkins/model/Jenkins/_safeRestart.jelly`
- E-36: `core/src/main/resources/hudson/AboutJenkins/index.jelly`
- E-37: `core/src/main/resources/hudson/PluginManager/index.jelly`
- E-38: `core/src/main/resources/hudson/PluginManager/installed.jelly`
- E-39: `core/src/main/resources/hudson/PluginManager/available.jelly`
- E-40: `core/src/main/resources/hudson/PluginManager/updates.jelly`
- E-41: `core/src/main/resources/hudson/PluginManager/advanced.jelly`
- E-42: `core/src/main/resources/hudson/model/UpdateCenter/index.jelly`
- E-43: `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/index.jelly`
- E-44: `core/src/main/resources/hudson/model/User/index.jelly`
- E-45: `core/src/main/resources/hudson/model/User/builds.jelly`
- E-46: `core/src/main/resources/hudson/model/userproperty/UserPropertyCategorySecurityAction/index.jelly`
- E-47: `core/src/main/resources/hudson/model/userproperty/UserPropertyCategoryPreferencesAction/index.jelly`
- E-48: `core/src/main/resources/hudson/model/userproperty/UserPropertyCategoryAppearanceAction/index.jelly`
- E-49: `core/src/main/resources/hudson/model/userproperty/UserPropertyCategoryAccountAction/index.jelly`
- E-50: `core/src/main/resources/hudson/model/userproperty/UserPropertyCategoryExperimentalAction/index.jelly`
- E-51: `core/src/main/resources/jenkins/install/SetupWizard/index.jelly`
- E-52: `core/src/main/resources/jenkins/install/SetupWizard/setupWizardFirstUser.jelly`
- E-53: `core/src/main/resources/jenkins/install/SetupWizard/setupWizardConfigureInstance.jelly`
- E-54: `core/src/main/resources/jenkins/install/SetupWizard/authenticate-security-token.jelly`
- E-55: `core/src/main/resources/jenkins/install/SetupWizard/proxy-configuration.jelly`
- E-56: `core/src/main/resources/hudson/logging/LogRecorderManager/index.jelly`
- E-57: `core/src/main/resources/hudson/logging/LogRecorder/index.jelly`
- E-58: `core/src/main/resources/hudson/model/Label/index.jelly`
- E-59: `core/src/main/resources/hudson/cli/CLIAction/index.jelly`
- E-60: `core/src/main/resources/jenkins/model/Jenkins/_script.jelly`
- E-61: `core/src/main/resources/hudson/diagnosis/MemoryUsageMonitor/index.jelly`
- E-62: `core/src/main/resources/hudson/diagnosis/HudsonHomeDiskUsageMonitor/index.jelly`
- E-63: `core/src/main/resources/hudson/util/RemotingDiagnostics/HeapDump/index.jelly`
- E-64: `core/src/main/resources/jenkins/diagnosis/HsErrPidList/index.jelly`
- E-65: `core/src/main/resources/hudson/model/Api/index.jelly`
- E-66: `core/src/main/resources/jenkins/model/Jenkins/fingerprintCheck.jelly`
- E-67: `core/src/main/resources/hudson/model/Fingerprint/index.jelly`
- E-68: `core/src/main/resources/jenkins/model/Jenkins/projectRelationship.jelly`
- E-69: `core/src/main/resources/jenkins/model/Jenkins/_404.jelly`
- E-70: `core/src/main/resources/jenkins/model/Jenkins/oops.jelly`
- E-71: `core/src/main/resources/hudson/util/HudsonIsLoading/index.jelly`
- E-72: `core/src/main/resources/hudson/util/HudsonIsRestarting/index.jelly`
- E-73: `core/src/main/resources/hudson/util/HudsonFailedToLoad/index.jelly`
- E-74: `core/src/main/resources/jenkins/appearance/AppearanceGlobalConfiguration/index.jelly`
- E-75: `core/src/main/resources/jenkins/security/csp/impl/CspRecommendation/index.jelly`
- E-76: `core/src/main/resources/hudson/model/View/configure.jelly`
- E-77: `core/src/main/resources/hudson/model/View/builds.jelly`
- E-78: `core/src/main/resources/hudson/ProxyConfiguration/index.jelly`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ダッシュボード（View一覧）画面の存在 | E-01 | ○ |
| C-02 | 新規ジョブ作成画面の存在 | E-02 | ○ |
| C-03 | 新規View作成画面の存在 | E-03 | ○ |
| C-04 | ログイン画面の存在 | E-04 | ○ |
| C-05 | ログインエラー画面の存在 | E-05 | ○ |
| C-06 | アクセス拒否画面の存在 | E-06 | ○ |
| C-07 | ユーザー登録（サインアップ）画面の存在 | E-07 | ○ |
| C-08 | ユーザー追加（管理者）画面の存在 | E-08 | ○ |
| C-09 | 初回ユーザー作成画面の存在 | E-09 | ○ |
| C-10 | Who Am I画面の存在 | E-10 | ○ |
| C-11 | ジョブ詳細画面の存在 | E-11 | ○ |
| C-12 | ジョブ設定画面の存在 | E-12 | ○ |
| C-13 | ビルド時間傾向画面の存在 | E-13 | ○ |
| C-14 | ビルド詳細画面の存在 | E-14 | ○ |
| C-15 | コンソール出力画面の存在 | E-15 | ○ |
| C-16 | コンソール出力（フル）画面の存在 | E-16 | ○ |
| C-17 | ビルド設定画面の存在 | E-17 | ○ |
| C-18 | ビルド削除確認画面の存在 | E-18 | ○ |
| C-19 | 成果物一覧画面の存在 | E-19 | ○ |
| C-20 | パラメータ入力画面の存在 | E-20 | ○ |
| C-21 | ノード一覧画面の存在 | E-21 | ○ |
| C-22 | ノード詳細画面の存在 | E-22 | ○ |
| C-23 | ノード設定画面の存在 | E-23 | ○ |
| C-24 | ノード負荷統計画面の存在 | E-24 | ○ |
| C-25 | ノードオフライン設定画面の存在 | E-25 | ○ |
| C-26 | クラウド一覧画面の存在 | E-26 | ○ |
| C-27 | クラウド詳細画面の存在 | E-27 | ○ |
| C-28 | Jenkins管理画面の存在 | E-28 | ○ |
| C-29 | システム設定画面の存在 | E-29 | ○ |
| C-30 | エグゼキュータ設定画面の存在 | E-30 | ○ |
| C-31 | システム情報画面の存在 | E-31 | ○ |
| C-32 | 負荷統計画面の存在 | E-32 | ○ |
| C-33 | スレッドダンプ画面の存在 | E-33 | ○ |
| C-34 | 再起動画面の存在 | E-34 | ○ |
| C-35 | 安全な再起動画面の存在 | E-35 | ○ |
| C-36 | Jenkinsについて画面の存在 | E-36 | ○ |
| C-37 | プラグイン管理トップ画面の存在 | E-37 | ○ |
| C-38 | インストール済みプラグイン画面の存在 | E-38 | ○ |
| C-39 | 利用可能なプラグイン画面の存在 | E-39 | ○ |
| C-40 | 更新可能なプラグイン画面の存在 | E-40 | ○ |
| C-41 | プラグイン詳細設定画面の存在 | E-41 | ○ |
| C-42 | 更新センター画面の存在 | E-42 | ○ |
| C-43 | ユーザー一覧画面の存在 | E-43 | ○ |
| C-44 | ユーザー詳細画面の存在 | E-44 | ○ |
| C-45 | ユーザービルド一覧画面の存在 | E-45 | ○ |
| C-46 | ユーザーセキュリティ設定画面の存在 | E-46 | ○ |
| C-47 | ユーザー表示設定画面の存在 | E-47 | ○ |
| C-48 | ユーザー外観設定画面の存在 | E-48 | ○ |
| C-49 | ユーザーアカウント設定画面の存在 | E-49 | ○ |
| C-50 | ユーザー実験的機能設定画面の存在 | E-50 | ○ |
| C-51 | セットアップウィザード画面の存在 | E-51 | ○ |
| C-52 | 初回ユーザー作成（ウィザード）画面の存在 | E-52 | ○ |
| C-53 | インスタンス設定画面の存在 | E-53 | ○ |
| C-54 | セキュリティトークン認証画面の存在 | E-54 | ○ |
| C-55 | プロキシ設定画面の存在 | E-55 | ○ |
| C-56 | ログレコーダー一覧画面の存在 | E-56 | ○ |
| C-57 | ログレコーダー詳細画面の存在 | E-57 | ○ |
| C-58 | ラベル詳細画面の存在 | E-58 | ○ |
| C-59 | CLI操作画面の存在 | E-59 | ○ |
| C-60 | スクリプトコンソール画面の存在 | E-60 | ○ |
| C-61 | メモリ使用状況画面の存在 | E-61 | ○ |
| C-62 | ディスク使用状況画面の存在 | E-62 | ○ |
| C-63 | ヒープダンプ画面の存在 | E-63 | ○ |
| C-64 | JVMクラッシュログ一覧画面の存在 | E-64 | ○ |
| C-65 | API情報画面の存在 | E-65 | ○ |
| C-66 | フィンガープリント検索画面の存在 | E-66 | ○ |
| C-67 | フィンガープリント詳細画面の存在 | E-67 | ○ |
| C-68 | プロジェクト関係図画面の存在 | E-68 | ○ |
| C-69 | 404エラー画面の存在 | E-69 | ○ |
| C-70 | 500エラー（Oops）画面の存在 | E-70 | ○ |
| C-71 | ローディング中画面の存在 | E-71 | ○ |
| C-72 | 再起動中画面の存在 | E-72 | ○ |
| C-73 | 起動エラー画面の存在 | E-73 | ○ |
| C-74 | 外観設定画面の存在 | E-74 | ○ |
| C-75 | CSP推奨設定画面の存在 | E-75 | ○ |
| C-76 | View設定画面の存在 | E-76 | ○ |
| C-77 | ビルド一覧（View）画面の存在 | E-77 | ○ |
| C-78 | プロキシ設定画面の存在 | E-78 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません

**補足事項:**
- 本一覧はJenkinsコア（core）のみを対象としています
- プラグインにより追加される画面は含まれていません
- 画面の詳細な機能説明は、対応するJellyファイルの内容から推測しています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全項目にソースコード上の根拠（Jellyファイル）が存在
- プラグイン画面の欠落については意図的な除外であり、リスクとは見なしません

## 6) レビュアーチェックリスト（最小）
- [ ] 各画面のカテゴリ分類が適切か確認
- [ ] 画面名と説明がJellyファイルの実際の機能と一致しているか確認
- [ ] 画面遷移図の遷移パスがコード上のリンク構造と一致しているか確認
- [ ] プラグインにより追加される重要な画面が漏れていないか確認（スコープ外だが影響度を評価）
- [ ] 備考欄の条件（初回起動時のみ、権限必要等）が正確か確認
