# Jenkins 画面遷移図

本ドキュメントは、Jenkins CI/CDサーバーの画面遷移関係をmermaid形式で記述したものです。

## 全体概要

```mermaid
flowchart TB
    subgraph セットアップ
        SW[セットアップウィザード]
        SW_TOKEN[セキュリティトークン認証]
        SW_USER[初回ユーザー作成]
        SW_INSTANCE[インスタンス設定]
        SW_PROXY[プロキシ設定]
    end

    subgraph 認証
        LOGIN[ログイン]
        LOGIN_ERROR[ログインエラー]
        SIGNUP[ユーザー登録]
        ACCESS_DENIED[アクセス拒否]
        WHOAMI[Who Am I]
    end

    subgraph ダッシュボード
        DASHBOARD[ダッシュボード]
        NEW_JOB[新規ジョブ作成]
        NEW_VIEW[新規View作成]
        VIEW_CONFIG[View設定]
        VIEW_BUILDS[ビルド一覧]
    end

    subgraph ジョブ管理
        JOB[ジョブ詳細]
        JOB_CONFIG[ジョブ設定]
        JOB_BUILD_TREND[ビルド時間傾向]
        PARAM_INPUT[パラメータ入力]
    end

    subgraph ビルド管理
        BUILD[ビルド詳細]
        CONSOLE[コンソール出力]
        CONSOLE_FULL[コンソール出力フル]
        BUILD_CONFIG[ビルド設定]
        BUILD_DELETE[ビルド削除確認]
        ARTIFACTS[成果物一覧]
    end

    subgraph ノード管理
        NODES[ノード一覧]
        NODE[ノード詳細]
        NODE_CONFIG[ノード設定]
        NODE_STATS[負荷統計]
        NODE_OFFLINE[オフライン設定]
        CLOUDS[クラウド一覧]
        CLOUD[クラウド詳細]
    end

    subgraph システム管理
        MANAGE[Jenkins管理]
        SYS_CONFIG[システム設定]
        EXEC_CONFIG[エグゼキュータ設定]
        SYS_INFO[システム情報]
        LOAD_STATS[負荷統計]
        THREAD_DUMP[スレッドダンプ]
        RESTART[再起動]
        SAFE_RESTART[安全な再起動]
        ABOUT[Jenkinsについて]
        SCRIPT[スクリプトコンソール]
    end

    subgraph プラグイン管理
        PLUGIN_TOP[プラグイン管理]
        PLUGIN_INSTALLED[インストール済み]
        PLUGIN_AVAILABLE[利用可能]
        PLUGIN_UPDATES[更新可能]
        PLUGIN_ADVANCED[詳細設定]
        UPDATE_CENTER[更新センター]
    end

    subgraph ユーザー管理
        USERS[ユーザー一覧]
        USER[ユーザー詳細]
        USER_BUILDS[ユーザービルド]
        ADD_USER[ユーザー追加]
        USER_SECURITY[セキュリティ設定]
        USER_PREFS[表示設定]
        USER_APPEARANCE[外観設定]
        USER_ACCOUNT[アカウント設定]
    end

    subgraph その他
        CLI[CLI操作]
        API[API情報]
        FINGERPRINT_CHECK[フィンガープリント検索]
        FINGERPRINT[フィンガープリント詳細]
        PROJECT_REL[プロジェクト関係図]
        LABEL[ラベル詳細]
        LOG_LIST[ログレコーダー一覧]
        LOG[ログレコーダー詳細]
        APPEARANCE_CONFIG[外観設定]
        PROXY_CONFIG[プロキシ設定]
    end

    %% セットアップフロー
    SW_TOKEN --> SW
    SW --> SW_USER
    SW_USER --> SW_INSTANCE
    SW --> SW_PROXY
    SW_INSTANCE --> DASHBOARD

    %% 認証フロー
    LOGIN --> DASHBOARD
    LOGIN --> LOGIN_ERROR
    LOGIN_ERROR --> LOGIN
    SIGNUP --> LOGIN
    ACCESS_DENIED --> LOGIN

    %% ダッシュボードフロー
    DASHBOARD --> NEW_JOB
    DASHBOARD --> NEW_VIEW
    DASHBOARD --> JOB
    DASHBOARD --> VIEW_CONFIG
    DASHBOARD --> VIEW_BUILDS
    NEW_JOB --> JOB_CONFIG
    NEW_VIEW --> DASHBOARD

    %% ジョブフロー
    JOB --> JOB_CONFIG
    JOB --> BUILD
    JOB --> JOB_BUILD_TREND
    JOB --> PARAM_INPUT
    JOB_CONFIG --> JOB
    PARAM_INPUT --> BUILD

    %% ビルドフロー
    BUILD --> CONSOLE
    BUILD --> CONSOLE_FULL
    BUILD --> BUILD_CONFIG
    BUILD --> BUILD_DELETE
    BUILD --> ARTIFACTS
    CONSOLE --> CONSOLE_FULL
    BUILD_DELETE --> JOB
    BUILD_CONFIG --> BUILD

    %% ノード管理フロー
    NODES --> NODE
    NODES --> CLOUDS
    NODE --> NODE_CONFIG
    NODE --> NODE_STATS
    NODE --> NODE_OFFLINE
    NODE_CONFIG --> NODE
    CLOUDS --> CLOUD
    CLOUD --> CLOUDS

    %% システム管理フロー
    MANAGE --> SYS_CONFIG
    MANAGE --> EXEC_CONFIG
    MANAGE --> SYS_INFO
    MANAGE --> LOAD_STATS
    MANAGE --> THREAD_DUMP
    MANAGE --> SCRIPT
    MANAGE --> PLUGIN_TOP
    MANAGE --> ABOUT
    MANAGE --> NODES
    MANAGE --> USERS
    MANAGE --> LOG_LIST
    MANAGE --> APPEARANCE_CONFIG
    MANAGE --> PROXY_CONFIG
    SYS_CONFIG --> MANAGE
    SYS_CONFIG --> RESTART
    SYS_CONFIG --> SAFE_RESTART

    %% プラグイン管理フロー
    PLUGIN_TOP --> PLUGIN_INSTALLED
    PLUGIN_TOP --> PLUGIN_AVAILABLE
    PLUGIN_TOP --> PLUGIN_UPDATES
    PLUGIN_TOP --> PLUGIN_ADVANCED
    PLUGIN_AVAILABLE --> UPDATE_CENTER
    PLUGIN_UPDATES --> UPDATE_CENTER
    UPDATE_CENTER --> PLUGIN_INSTALLED

    %% ユーザー管理フロー
    USERS --> USER
    USERS --> ADD_USER
    USER --> USER_BUILDS
    USER --> USER_SECURITY
    USER --> USER_PREFS
    USER --> USER_APPEARANCE
    USER --> USER_ACCOUNT
    ADD_USER --> USERS

    %% その他フロー
    MANAGE --> CLI
    MANAGE --> FINGERPRINT_CHECK
    FINGERPRINT_CHECK --> FINGERPRINT
    JOB --> PROJECT_REL
    NODE --> LABEL
    LOG_LIST --> LOG
```

## 認証フロー詳細

```mermaid
flowchart LR
    subgraph 未認証状態
        ANON[匿名アクセス]
    end

    subgraph 認証プロセス
        LOGIN[ログイン画面]
        LOGIN_ERROR[ログインエラー]
        SIGNUP[ユーザー登録]
        FIRST_USER[初回ユーザー作成]
    end

    subgraph 認証済み状態
        DASHBOARD[ダッシュボード]
        WHOAMI[Who Am I]
        LOGOUT[ログアウト]
    end

    subgraph エラー状態
        ACCESS_DENIED[アクセス拒否]
    end

    ANON -->|ログイン必要| LOGIN
    ANON -->|セルフサインアップ| SIGNUP
    ANON -->|初回起動| FIRST_USER

    LOGIN -->|認証成功| DASHBOARD
    LOGIN -->|認証失敗| LOGIN_ERROR
    LOGIN_ERROR -->|再試行| LOGIN

    SIGNUP -->|登録完了| LOGIN
    FIRST_USER -->|作成完了| LOGIN

    DASHBOARD -->|権限確認| WHOAMI
    DASHBOARD -->|ログアウト| LOGOUT
    LOGOUT --> LOGIN

    DASHBOARD -->|権限不足| ACCESS_DENIED
    ACCESS_DENIED -->|ログイン| LOGIN
```

## ジョブ・ビルドフロー詳細

```mermaid
flowchart TB
    subgraph ジョブ操作
        DASHBOARD[ダッシュボード]
        NEW_JOB[新規ジョブ作成]
        JOB[ジョブ詳細]
        JOB_CONFIG[ジョブ設定]
        BUILD_TREND[ビルド時間傾向]
    end

    subgraph ビルド実行
        PARAM_INPUT[パラメータ入力]
        BUILD_NOW[ビルド実行]
    end

    subgraph ビルド結果
        BUILD[ビルド詳細]
        CONSOLE[コンソール出力]
        CONSOLE_FULL[コンソール出力フル]
        ARTIFACTS[成果物一覧]
        BUILD_CONFIG[ビルド設定]
        BUILD_DELETE[ビルド削除]
    end

    DASHBOARD -->|新規作成| NEW_JOB
    NEW_JOB -->|ジョブ種類選択| JOB_CONFIG
    JOB_CONFIG -->|保存| JOB

    DASHBOARD -->|ジョブ選択| JOB
    JOB -->|設定| JOB_CONFIG
    JOB -->|ビルド傾向| BUILD_TREND

    JOB -->|パラメータなしビルド| BUILD_NOW
    JOB -->|パラメータ付きビルド| PARAM_INPUT
    PARAM_INPUT -->|ビルド実行| BUILD_NOW
    BUILD_NOW -->|ビルド開始| BUILD

    JOB -->|ビルド履歴から| BUILD
    BUILD -->|コンソール| CONSOLE
    CONSOLE -->|全ログ| CONSOLE_FULL
    BUILD -->|成果物| ARTIFACTS
    BUILD -->|設定変更| BUILD_CONFIG
    BUILD -->|削除| BUILD_DELETE
    BUILD_DELETE -->|削除後| JOB
```

## システム管理フロー詳細

```mermaid
flowchart TB
    subgraph Jenkins管理
        MANAGE[Jenkins管理メニュー]
    end

    subgraph システム設定
        SYS_CONFIG[システム設定]
        EXEC_CONFIG[エグゼキュータ設定]
        APPEARANCE[外観設定]
        PROXY[プロキシ設定]
    end

    subgraph 監視・診断
        SYS_INFO[システム情報]
        LOAD_STATS[負荷統計]
        THREAD_DUMP[スレッドダンプ]
        MEMORY[メモリ使用状況]
        DISK[ディスク使用状況]
        HEAP_DUMP[ヒープダンプ]
    end

    subgraph セキュリティ
        SECURITY_CONFIG[セキュリティ設定]
        SCRIPT[スクリプトコンソール]
        CLI[CLI操作]
    end

    subgraph 保守
        RESTART[再起動]
        SAFE_RESTART[安全な再起動]
        ABOUT[Jenkinsについて]
    end

    MANAGE --> SYS_CONFIG
    MANAGE --> EXEC_CONFIG
    MANAGE --> APPEARANCE
    MANAGE --> PROXY

    MANAGE --> SYS_INFO
    MANAGE --> LOAD_STATS
    MANAGE --> THREAD_DUMP
    SYS_INFO --> MEMORY
    SYS_INFO --> DISK
    THREAD_DUMP --> HEAP_DUMP

    MANAGE --> SECURITY_CONFIG
    MANAGE --> SCRIPT
    MANAGE --> CLI

    MANAGE --> RESTART
    MANAGE --> SAFE_RESTART
    MANAGE --> ABOUT

    SYS_CONFIG -->|設定後| RESTART
    SYS_CONFIG -->|設定後| SAFE_RESTART
```

## プラグイン管理フロー詳細

```mermaid
flowchart LR
    subgraph プラグイン一覧
        PLUGIN_TOP[プラグイン管理トップ]
        INSTALLED[インストール済み]
        AVAILABLE[利用可能]
        UPDATES[更新可能]
        ADVANCED[詳細設定]
    end

    subgraph 操作
        INSTALL[インストール]
        UPDATE[更新]
        UNINSTALL[アンインストール]
        ENABLE[有効化]
        DISABLE[無効化]
        UPLOAD[アップロード]
    end

    subgraph 結果
        UPDATE_CENTER[更新センター]
        RESTART_REQUIRED[再起動が必要]
    end

    PLUGIN_TOP --> INSTALLED
    PLUGIN_TOP --> AVAILABLE
    PLUGIN_TOP --> UPDATES
    PLUGIN_TOP --> ADVANCED

    AVAILABLE -->|選択| INSTALL
    UPDATES -->|選択| UPDATE
    INSTALLED -->|選択| UNINSTALL
    INSTALLED -->|選択| ENABLE
    INSTALLED -->|選択| DISABLE
    ADVANCED -->|ファイル選択| UPLOAD

    INSTALL --> UPDATE_CENTER
    UPDATE --> UPDATE_CENTER
    UPLOAD --> UPDATE_CENTER
    UPDATE_CENTER --> RESTART_REQUIRED
    UNINSTALL --> RESTART_REQUIRED
```

## ノード管理フロー詳細

```mermaid
flowchart TB
    subgraph ノード一覧
        NODES[ノード一覧]
        NEW_NODE[新規ノード作成]
    end

    subgraph ノード詳細
        NODE[ノード詳細]
        NODE_CONFIG[ノード設定]
        NODE_STATS[負荷統計]
        NODE_LOG[システムログ]
        NODE_BUILDS[ビルド一覧]
    end

    subgraph ノード状態
        ONLINE[オンライン]
        OFFLINE[オフライン]
        MARK_OFFLINE[オフライン設定]
        DISCONNECT[切断]
        CONNECT[接続]
    end

    subgraph クラウド
        CLOUDS[クラウド一覧]
        CLOUD[クラウド詳細]
        CLOUD_CONFIG[クラウド設定]
    end

    NODES --> NEW_NODE
    NODES --> NODE
    NODES --> CLOUDS

    NEW_NODE --> NODE_CONFIG
    NODE_CONFIG --> NODE

    NODE --> NODE_STATS
    NODE --> NODE_LOG
    NODE --> NODE_BUILDS
    NODE --> NODE_CONFIG

    NODE -->|状態: オンライン| ONLINE
    NODE -->|状態: オフライン| OFFLINE

    ONLINE --> MARK_OFFLINE
    MARK_OFFLINE --> OFFLINE
    ONLINE --> DISCONNECT
    DISCONNECT --> OFFLINE
    OFFLINE --> CONNECT
    CONNECT --> ONLINE

    CLOUDS --> CLOUD
    CLOUD --> CLOUD_CONFIG
    CLOUD_CONFIG --> CLOUD
```

## セットアップウィザードフロー

```mermaid
flowchart TB
    subgraph 初回起動
        START[Jenkins起動]
        LOADING[ローディング中]
    end

    subgraph セットアップウィザード
        TOKEN[セキュリティトークン入力]
        WIZARD[ウィザードメイン]
        PROXY[プロキシ設定]
        PLUGINS[プラグイン選択]
        INSTALL_PLUGINS[プラグインインストール]
        CREATE_USER[管理者ユーザー作成]
        INSTANCE_CONFIG[インスタンス設定]
    end

    subgraph 完了
        DASHBOARD[ダッシュボード]
    end

    START --> LOADING
    LOADING --> TOKEN
    TOKEN -->|認証成功| WIZARD
    TOKEN -->|認証失敗| TOKEN

    WIZARD --> PROXY
    PROXY --> PLUGINS
    WIZARD --> PLUGINS

    PLUGINS -->|推奨プラグイン| INSTALL_PLUGINS
    PLUGINS -->|カスタム選択| INSTALL_PLUGINS
    PLUGINS -->|スキップ| CREATE_USER

    INSTALL_PLUGINS --> CREATE_USER
    CREATE_USER --> INSTANCE_CONFIG
    INSTANCE_CONFIG --> DASHBOARD
```

## 画面カテゴリ別一覧

| カテゴリ | 画面数 | 主要画面 |
|---------|--------|---------|
| ダッシュボード | 5 | ダッシュボード、新規ジョブ作成、新規View作成 |
| 認証/セキュリティ | 7 | ログイン、ユーザー登録、アクセス拒否 |
| ジョブ管理 | 4 | ジョブ詳細、ジョブ設定、パラメータ入力 |
| ビルド管理 | 7 | ビルド詳細、コンソール出力、成果物一覧 |
| ノード管理 | 7 | ノード一覧、ノード詳細、クラウド一覧 |
| システム管理 | 10 | Jenkins管理、システム設定、システム情報 |
| プラグイン管理 | 6 | インストール済み、利用可能、更新可能 |
| ユーザー管理 | 10 | ユーザー一覧、ユーザー詳細、各種設定 |
| セットアップウィザード | 5 | ウィザード、ユーザー作成、インスタンス設定 |
| 診断/トラブルシューティング | 4 | メモリ使用状況、ディスク使用状況 |
| その他 | 13 | API、CLI、フィンガープリント |

## 備考

- 本画面遷移図はJenkinsコアの画面のみを対象としています
- プラグインにより追加される画面は含まれていません
- 一部の画面は条件（初回起動、権限、設定等）により表示が異なります
- mermaid図は主要な遷移パスを示しており、全てのリンクを網羅していません
