---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 125
  claims_with_evidence: 118
  claims_without_evidence: 7
confidence_derived: 0.94
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：118 / 125、根拠なし：7
- 優先レビュー（高）
  1. **CSP推奨設定と認証機能の関連**：セキュリティ機能との正確な関連付けを要確認
  2. **クラウドプロビジョニング関連画面**：クラウド機能の実装詳細が不明確
  3. **実験的機能設定**：実験的機能フラグの詳細な仕様確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（78画面）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（70機能）
- E-03: `core/src/main/resources/hudson/model/View/index.jelly` - ダッシュボード画面実装
- E-04: `core/src/main/resources/hudson/model/View/newJob.jelly` - 新規ジョブ作成画面実装
- E-05: `core/src/main/resources/hudson/model/Job/index.jelly` - ジョブ詳細画面実装
- E-06: `core/src/main/resources/hudson/model/Job/configure.jelly` - ジョブ設定画面実装
- E-07: `core/src/main/resources/hudson/model/Run/index.jelly` - ビルド詳細画面実装
- E-08: `core/src/main/resources/hudson/model/Run/console.jelly` - コンソール出力画面実装
- E-09: `core/src/main/resources/jenkins/model/Jenkins/login.jelly` - ログイン画面実装
- E-10: `core/src/main/resources/hudson/model/ComputerSet/index.jelly` - ノード一覧画面実装
- E-11: `core/src/main/resources/hudson/model/Computer/index.jelly` - ノード詳細画面実装
- E-12: `core/src/main/resources/jenkins/model/Jenkins/configure.jelly` - システム設定画面実装
- E-13: `core/src/main/resources/hudson/PluginManager/index.jelly` - プラグイン管理画面実装
- E-14: `core/src/main/resources/hudson/model/User/index.jelly` - ユーザー詳細画面実装
- E-15: `core/src/main/resources/jenkins/install/SetupWizard/index.jelly` - セットアップウィザード画面実装
- E-16: `core/src/main/resources/hudson/cli/CLIAction/index.jelly` - CLI操作画面実装
- E-17: `core/src/main/resources/hudson/model/Api/index.jelly` - API情報画面実装
- E-18: `core/src/main/resources/hudson/model/Label/index.jelly` - ラベル詳細画面実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ダッシュボード画面はビュー管理機能を主機能として使用 | E-01, E-02, E-03 | ○ |
| C-02 | ダッシュボード画面はダッシュボード機能を主機能として使用 | E-01, E-02, E-03 | ○ |
| C-03 | ダッシュボード画面はジョブ一覧表示にジョブ機能を使用 | E-03 | ○ |
| C-04 | ダッシュボード画面はキュー管理機能とAPI連携 | E-03 | ○ |
| C-05 | 新規ジョブ作成画面はジョブ機能を主機能として使用 | E-01, E-02, E-04 | ○ |
| C-06 | 新規ジョブ作成画面はフリースタイルプロジェクトタイプを補助機能として使用 | E-04 | ○ |
| C-07 | 新規ジョブ作成画面はフォームバリデーションとAPI連携 | E-04 | ○ |
| C-08 | ログイン画面は認証機能を主機能として使用 | E-01, E-02, E-09 | ○ |
| C-09 | ログイン画面はCSRF保護機能を補助機能として使用 | E-09 | ○ |
| C-10 | ジョブ詳細画面はジョブ機能を主機能として使用 | E-01, E-02, E-05 | ○ |
| C-11 | ジョブ詳細画面はビルド機能を補助機能として使用（ビルド履歴表示） | E-05 | ○ |
| C-12 | ジョブ設定画面はジョブ機能を主機能として使用 | E-01, E-02, E-06 | ○ |
| C-13 | ジョブ設定画面はSCM連携機能を補助機能として使用 | E-06 | ○ |
| C-14 | ジョブ設定画面はビルドトリガー機能を補助機能として使用 | E-06 | ○ |
| C-15 | ビルド詳細画面はビルド機能を主機能として使用 | E-01, E-02, E-07 | ○ |
| C-16 | ビルド詳細画面は成果物アーカイブ機能を補助機能として使用 | E-07 | ○ |
| C-17 | コンソール出力画面はビルド機能を主機能として使用 | E-01, E-02, E-08 | ○ |
| C-18 | ノード一覧画面はコンピューター管理機能を主機能として使用 | E-01, E-02, E-10 | ○ |
| C-19 | ノード一覧画面はノードモニター機能を補助機能として使用 | E-10 | ○ |
| C-20 | ノード詳細画面はコンピューター管理機能を主機能として使用 | E-01, E-02, E-11 | ○ |
| C-21 | ノード詳細画面はラベル管理機能を補助機能として使用 | E-11 | ○ |
| C-22 | システム設定画面はシステム設定機能を主機能として使用 | E-01, E-02, E-12 | ○ |
| C-23 | システム設定画面はJenkins本体機能を補助機能として使用 | E-12 | ○ |
| C-24 | プラグイン管理画面はプラグインマネージャー機能を主機能として使用 | E-01, E-02, E-13 | ○ |
| C-25 | ユーザー詳細画面はユーザー管理機能を主機能として使用 | E-01, E-02, E-14 | ○ |
| C-26 | セットアップウィザードは初期化フレームワーク機能を主機能として使用 | E-01, E-02, E-15 | ○ |
| C-27 | CLI操作画面はCLIコマンド基盤機能を主機能として使用 | E-01, E-02, E-16 | ○ |
| C-28 | API情報画面はREST API機能を主機能として使用 | E-01, E-02, E-17 | ○ |
| C-29 | ラベル詳細画面はラベル管理機能を主機能として使用 | E-01, E-02, E-18 | ○ |
| C-30 | クラウド一覧画面はクラウドプロビジョニング機能を主機能として使用 | E-01, E-02 | △ |
| C-31 | クラウド詳細画面はクラウドプロビジョニング機能を主機能として使用 | E-01, E-02 | △ |
| C-32 | CSP推奨設定画面は認証機能を主機能として使用 | E-01, E-02 | △ |
| C-33 | CSP推奨設定画面は機密情報管理機能を補助機能として使用 | E-01, E-02 | △ |
| C-34 | ユーザー実験的機能設定画面はユーザー管理機能を主機能として使用 | E-01, E-02 | △ |
| C-35 | パラメータ入力画面の各パラメータタイプ（文字列、選択、ブール）との関連 | E-01, E-02 | △ |
| C-36 | フィンガープリント関連画面とフィンガープリント機能の関連 | E-01, E-02 | △ |

## 4) 不足情報（Unknown / Missing）
- クラウドプロビジョニング関連画面（画面No.26, 27）の実装詳細
  - 候補：`core/src/main/resources/jenkins/agents/CloudSet/index.jelly` / `core/src/main/resources/hudson/slaves/Cloud/index.jelly`
- CSP推奨設定画面（画面No.75）と認証機能の具体的な関連性
  - 候補：`core/src/main/resources/jenkins/security/csp/impl/CspRecommendation/index.jelly`
- 実験的機能設定画面（画面No.50）の詳細な仕様
  - 候補：`core/src/main/resources/hudson/model/userproperty/UserPropertyCategoryExperimentalAction/index.jelly`
- パラメータ入力画面（画面No.20）の各パラメータタイプ実装
  - 候補：`core/src/main/resources/hudson/model/ParametersDefinitionProperty/index.jelly`

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：主要な画面と機能のマッピングは根拠が明確
- 1（中リスク）：クラウドプロビジョニング関連機能のマッピング - プラグイン依存の可能性
- 1（中リスク）：CSP設定画面の機能分類 - セキュリティ機能との関連が間接的
- 0（低リスク）：ユーザー管理関連画面のマッピングは一貫性あり

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧の全78画面がマッピングに含まれているか確認
- [ ] 機能一覧の主要機能が適切な画面にマッピングされているか確認
- [ ] 関連種別（主機能/補助機能/遷移先機能/API連携）の分類が適切か確認
- [ ] クラウドプロビジョニング関連画面（26, 27）のマッピングが正確か確認
- [ ] CSP推奨設定画面（75）の機能分類が適切か確認
- [ ] 各画面の「関連する操作・処理」の説明が実装と一致しているか確認
