# 画面設計書 1-ダッシュボード（View一覧）

## 概要

本ドキュメントは、Jenkinsのメインダッシュボード画面（View一覧）の設計仕様を定義するものです。

### 本画面の処理概要

Jenkinsのメインダッシュボード画面は、CI/CDパイプライン管理の中核となる画面であり、登録されているジョブ（プロジェクト）の一覧表示と状態監視を行います。

**業務上の目的・背景**：開発チームがビルド・デプロイの状況を一目で把握し、必要なアクションを迅速に実行できるようにすることが目的です。ジョブの成功/失敗状態、ビルドキューの状況、最終ビルド時刻などの情報を集約表示することで、継続的インテグレーション・継続的デリバリーの効率的な運用を支援します。

**画面へのアクセス方法**：JenkinsのルートURL（例：http://localhost:8080/）にアクセスするか、ヘッダーのJenkinsロゴをクリックすることでアクセスできます。また、特定のViewを表示する場合は `/view/{ViewName}/` のURLパターンでアクセスします。

**主要な操作・処理内容**：
1. ジョブ一覧の表示と各ジョブの状態（成功/失敗/未実行等）の確認
2. ジョブ名クリックによるジョブ詳細画面への遷移
3. ビルドボタンによる即座のビルド実行
4. 新規ジョブ作成画面への遷移
5. View（タブ）の切り替えによるジョブのフィルタリング表示
6. システムメッセージの表示
7. ビルドキューとエグゼキュータの状態確認

**画面遷移**：この画面からは新規ジョブ作成画面、新規View作成画面、ジョブ詳細画面、View設定画面、ビルド履歴画面へ遷移できます。ログイン後やセットアップウィザード完了後にこの画面に遷移してきます。

**権限による表示制御**：未ログインユーザーでもセキュリティ設定により閲覧可能な場合がありますが、ジョブ作成やビルド実行などの操作は適切な権限が必要です。View.READ権限がないジョブは一覧に表示されません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | ビュー管理 | 主機能 | View一覧の表示、ジョブのグルーピング表示 |
| 38 | ダッシュボード | 主機能 | メインページの表示、ナビゲーション |
| 4 | ジョブ（Job） | 補助機能 | ジョブ一覧の表示 |
| 7 | キュー管理 | API連携 | ビルドキューの状態表示 |

## 画面種別

一覧

## URL/ルーティング

- `/` - デフォルトViewの場合
- `/view/{viewName}/` - 特定のViewを表示する場合

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| システムメッセージ | 出力 | String | - | 管理者が設定したシステム全体のメッセージ |
| View説明 | 出力 | String | - | 現在のViewの説明文 |
| ジョブ一覧 | 出力 | Collection&lt;TopLevelItem&gt; | - | 表示対象のジョブリスト |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ジョブ名 | String | ジョブの表示名 |
| ジョブステータスアイコン | Icon | ジョブの最新ビルド状態を示すアイコン |
| 最終成功ビルド | String | 最後に成功したビルドの番号/時刻 |
| 最終失敗ビルド | String | 最後に失敗したビルドの番号/時刻 |
| 最終ビルド時間 | String | 最後にビルドされた時刻 |
| ビルドボタン | Button | 即座にビルドを開始するボタン |
| Viewタブ | Tab | 登録されているViewの一覧タブ |

## イベント仕様

### 1-ジョブ名クリック

ジョブ名をクリックすると、該当ジョブの詳細画面（`/job/{jobName}/`）へ遷移します。

### 2-ビルド実行ボタン押下

ビルドボタン（時計アイコン）をクリックすると、該当ジョブのビルドがキューに追加されます。パラメータ付きジョブの場合はパラメータ入力画面へ遷移します。

### 3-新規ジョブ作成リンク押下

サイドパネルの「新規ジョブ作成」リンクをクリックすると、新規ジョブ作成画面（`/view/{viewName}/newJob`）へ遷移します。

### 4-Viewタブ切り替え

Viewタブをクリックすると、選択されたViewに含まれるジョブのみが一覧に表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | SELECT | ジョブ情報、ビルド情報の読み込み |
| ビルド実行 | Queue | INSERT | ビルドキューへのジョブ追加 |

### テーブル別更新項目詳細

#### Jenkinsファイルシステム（$JENKINS_HOME/jobs/）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| SELECT | config.xml | ジョブ設定情報の読み込み | 各ジョブディレクトリ配下 |
| SELECT | builds/ | ビルド履歴情報の読み込み | ビルド番号ディレクトリ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| broken | エラー | "This view is broken" | Viewの設定に問題がある場合 |
| noJob | 情報 | ジョブが存在しない旨のメッセージ | View内にジョブがない場合 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| View.READ権限なし | ジョブが一覧に表示されない |
| View設定破損 | "This view is broken"メッセージを表示 |
| ジョブ0件 | noJob.jellyの内容を表示 |

## 備考

- 新旧UIの切り替え機能があり、`NewDashboardPageUserExperimentalFlag`が有効な場合は`new-view-page.jelly`が使用されます
- 画面解像度を検出するためのJavaScriptが組み込まれています（`screen-resolution.js`）
- RSSフィード（Atom/RSS 2.0形式）が提供されており、全ビルドまたは失敗ビルドのみの購読が可能です

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Viewとジョブ（TopLevelItem）の関係性を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | View.java | `core/src/main/java/hudson/model/View.java` | Viewの基本構造、getItems()メソッドでジョブ一覧を取得 |
| 1-2 | TopLevelItem.java | `core/src/main/java/hudson/model/TopLevelItem.java` | ジョブの基本インターフェース |

**読解のコツ**: ViewはAbstractModelObjectを継承し、AccessControlledを実装しています。権限チェックはACLを通じて行われます。

#### Step 2: エントリーポイントを理解する

画面表示の起点となるJellyテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/model/View/index.jelly` | 画面のメインテンプレート、新旧UI切り替えロジック |

**主要処理フロー**:
1. **26-28行目**: newDashboardPageフラグの取得
2. **29-31行目**: 新UIの場合はnew-view-page.jellyをインクルード
3. **34-57行目**: 従来UIの場合のレイアウト定義
4. **39-47行目**: view-index-top.jellyでオーナー固有の表示
5. **49-50行目**: ジョブ一覧の取得とmain.jellyのインクルード

#### Step 3: サイドパネルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | sidepanel.jelly | `core/src/main/resources/hudson/model/View/sidepanel.jelly` | サイドメニューの構成、新規ジョブ作成リンク等 |

**主要処理フロー**:
- **33-37行目**: RSSフィードリンクの生成
- **51-52行目**: 新規ジョブ作成タスクの表示（権限チェック付き）
- **55行目**: ビルド履歴リンク
- **77-80行目**: ウィジェットの表示

#### Step 4: メインコンテンツを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | main.jelly | `core/src/main/resources/hudson/model/View/main.jelly` | ジョブ一覧表示のメインロジック |

**主要処理フロー**:
- **8-9行目**: items変数がnullの場合のエラー表示
- **12-28行目**: ジョブが空の場合の処理
- **31-52行目**: projectViewタグでジョブ一覧をレンダリング

### プログラム呼び出し階層図

```
View.index.jelly (エントリーポイント)
    │
    ├─ sidepanel.jelly (サイドパネル)
    │      ├─ tasks-top.jelly (オーナー固有タスク)
    │      ├─ l:task (新規ジョブ作成等)
    │      └─ widgets (ウィジェット群)
    │
    ├─ view-index-top.jelly (トップセクション)
    │      └─ editableDescription (説明文編集)
    │
    └─ main.jelly (メインコンテンツ)
           ├─ noJob.jelly (ジョブなし時)
           └─ t:projectView (ジョブ一覧表示)
                  └─ viewTabs.jelly (Viewタブ)
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト ───▶ Stapler ───▶ View.java ───▶ index.jelly
                        │
                        ▼
                  getItems() ───▶ TopLevelItem一覧
                        │
                        ▼
                  main.jelly ───▶ HTML(ジョブ一覧テーブル)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| View.java | `core/src/main/java/hudson/model/View.java` | ソース | Viewの基底クラス、ジョブ一覧取得ロジック |
| index.jelly | `core/src/main/resources/hudson/model/View/index.jelly` | テンプレート | メイン画面テンプレート |
| sidepanel.jelly | `core/src/main/resources/hudson/model/View/sidepanel.jelly` | テンプレート | サイドパネルテンプレート |
| main.jelly | `core/src/main/resources/hudson/model/View/main.jelly` | テンプレート | ジョブ一覧表示テンプレート |
| new-view-page.jelly | `core/src/main/resources/hudson/model/View/new-view-page.jelly` | テンプレート | 新UI用テンプレート |
| screen-resolution.js | `core/src/main/resources/hudson/model/View/screen-resolution.js` | JavaScript | 画面解像度検出 |
| noJob.jelly | `core/src/main/resources/hudson/model/View/noJob.jelly` | テンプレート | ジョブなし時の表示 |
