# 画面設計書 11-ジョブ詳細

## 概要

本ドキュメントは、Jenkinsにおけるジョブ詳細画面の設計仕様を記述したものです。ジョブの基本情報、ビルド履歴、パーマリンク、および関連アクションを表示する中心的な画面です。

### 本画面の処理概要

**業務上の目的・背景**：ジョブ詳細画面は、CI/CDパイプラインの中核となるジョブ（プロジェクト）の状態を一目で把握するための画面です。開発者やDevOpsエンジニアは、この画面を通じてビルドの成功/失敗状況、最新ビルドの状態、ビルド履歴の傾向を確認し、必要に応じてビルドの実行や設定変更を行います。ジョブの健全性を監視し、問題発生時に迅速に対応するための情報ハブとして機能します。

**画面へのアクセス方法**：ダッシュボード（View一覧）画面からジョブ名をクリックすることでアクセスできます。また、URLに直接ジョブパス（例：`/job/{ジョブ名}/`）を指定してアクセスすることも可能です。他のビルド詳細画面やジョブ設定画面からサイドパネルのリンクを通じて遷移することもできます。

**主要な操作・処理内容**：
1. ジョブの基本情報（名前、説明、状態アイコン）の表示
2. ビルド履歴の一覧表示（HistoryWidgetによる遅延ロード）
3. パーマリンク（最新ビルド、最新成功ビルド、最新失敗ビルド等）へのクイックアクセス
4. ジョブプロパティのサマリー表示
5. サイドパネルからのビルド実行、設定変更、削除等のアクション

**画面遷移**：
- 遷移元：ダッシュボード、View画面、検索結果、他ジョブからのリンク
- 遷移先：ビルド詳細、ジョブ設定、ビルド時間傾向、パラメータ入力、コンソール出力

**権限による表示制御**：
- `Job.READ`権限がないとジョブ詳細画面自体にアクセスできません
- `Job.CONFIGURE`権限がある場合のみ、説明編集ボタンが表示されます
- `Job.BUILD`権限がある場合のみ、ビルド実行リンクが表示されます
- 新旧UIの切り替えは`NewJobPageUserExperimentalFlag`フラグで制御されます

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | ジョブ（Job） | 主機能 | ジョブの詳細情報表示 |
| 6 | ビルド（Build） | 補助機能 | ビルド履歴の表示 |
| 65 | REST API | API連携 | ジョブ情報のAPI提供 |

## 画面種別

詳細

## URL/ルーティング

```
/job/{ジョブ名}/
/job/{フォルダ名}/job/{ジョブ名}/
```

Staplerによりリクエストは`hudson.model.Job`クラスの`index.jelly`にルーティングされます。

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| displayName | 出力 | String | ジョブの表示名 |
| description | 出力 | String | ジョブの説明（マークアップ対応） |
| lastBuild | 出力 | Run | 最後のビルド情報 |
| fullName | 出力 | String | 完全修飾ジョブ名（フォルダ階層含む） |
| iconColor | 出力 | BallColor | ビルド状態を表すアイコン色 |

## 表示項目

| 項目 | 説明 | データソース |
|------|------|------------|
| ジョブ名 | ヘッドラインに表示されるジョブ名 | `Job.displayName` |
| 状態アイコン | 最新ビルドの状態を示すアイコン | `lastBuild.iconColor` |
| 説明 | ジョブの説明文（編集可能） | `Job.description` |
| 完全プロジェクト名 | フォルダ階層を含む完全名 | `Job.fullName` |
| ジョブプロパティサマリー | 設定されたプロパティの要約 | `jobpropertysummaries.jelly` |
| パーマリンク | 特定ビルドへのショートカット | `permalinks.jelly` |
| ビルド履歴 | 過去のビルド一覧 | `main.jelly` |

## イベント仕様

### 1-説明編集ボタン押下

`Job.CONFIGURE`権限がある場合に表示される編集ボタン。押下すると説明文をインライン編集できるモードに切り替わります。

- 処理フロー：
  1. 編集モードへの切り替え（JavaScript）
  2. テキストエリアでの編集
  3. 保存時にPOSTリクエストで`submitDescription`へ送信
  4. 成功後、画面を更新

### 2-サイドパネルからのビルド実行

サイドパネルの「ビルド実行」リンクを押下すると、パラメータ付きビルドの場合はパラメータ入力画面へ、そうでない場合は直接ビルドをキューに追加します。

### 3-設定リンク押下

サイドパネルの「設定」リンクを押下すると、ジョブ設定画面（configure.jelly）へ遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 説明編集・保存 | config.xml（ファイル） | UPDATE | ジョブ設定XMLの更新 |

### テーブル別更新項目詳細

#### config.xml

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | description | ユーザー入力値 | マークアップ形式でサニタイズ |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | メッセージ種別 |
|-------------|---------------|---------|--------------|
| Job.Pronoun | Project | デフォルト表記 | 情報 |
| Full project name | 完全プロジェクト名: {name} | フォルダ内ジョブの場合 | 情報 |
| Project name | プロジェクト名: {name} | トップレベルジョブの場合 | 情報 |

## 例外処理

| 例外条件 | 処理内容 | 画面表示 |
|---------|---------|---------|
| ジョブが存在しない | 404エラー画面へリダイレクト | 404エラー画面 |
| 権限不足 | アクセス拒否画面へリダイレクト | 403エラー画面 |
| ビルド履歴取得エラー | ログ出力、空リスト表示 | ビルド履歴なしと表示 |

## 備考

- 新UIと旧UIの切り替えは`NewJobPageUserExperimentalFlag`で制御されます。新UIを有効にした場合、`new-job-page.jelly`がレンダリングされます。
- MatrixConfigurationの場合、完全プロジェクト名の表示はスキップされます。
- ビルド履歴はProgressiveRenderingにより非同期で読み込まれ、大量のビルドがある場合でもページ表示が遅延しません。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ジョブとビルドの基本的なデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Job.java | `core/src/main/java/hudson/model/Job.java` | ジョブの基本クラス。displayName、description、ビルド履歴管理を理解する |
| 1-2 | Run.java | `core/src/main/java/hudson/model/Run.java` | ビルド実行の基本クラス。number、result、timestampを理解する |
| 1-3 | BallColor.java | `core/src/main/java/hudson/BallColor.java` | ビルド状態を表すアイコン色の列挙型 |

**読解のコツ**: Jobクラスは抽象クラスであり、具体的な実装（FreestyleProject等）は継承クラスにあります。`@Exported`アノテーションはREST APIで公開されるプロパティを示します。

#### Step 2: エントリーポイントを理解する

処理の起点となるJellyテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/model/Job/index.jelly` | ジョブ詳細画面のメインテンプレート |

**主要処理フロー**:
1. **29-31行目**: `newJobPage`フラグによる新旧UI切り替え判定
2. **34行目**: レイアウトのタイトル設定（displayName + 親フォルダ名）
3. **35行目**: サイドパネルのインクルード
4. **40-45行目**: 最新ビルドの状態アイコン表示
5. **46-48行目**: ジョブ名のヘッドライン表示
6. **65行目**: 編集可能な説明文の表示
7. **67行目**: ジョブプロパティサマリーのインクルード
8. **69行目**: メインコンテンツ（ビルド履歴等）のインクルード
9. **71行目**: パーマリンクのインクルード

#### Step 3: サイドパネルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | sidepanel.jelly | `core/src/main/resources/hudson/model/Job/sidepanel.jelly` | サイドパネルのアクションリンク |

**主要処理フロー**:
- ビルド実行、設定、削除等のアクションリンクを権限に応じて表示

#### Step 4: メインコンテンツを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | main.jelly | `core/src/main/resources/hudson/model/Job/main.jelly` | ビルド履歴ウィジェット等のメインコンテンツ |
| 4-2 | permalinks.jelly | `core/src/main/resources/hudson/model/Job/permalinks.jelly` | パーマリンク一覧の表示 |

#### Step 5: Javaバックエンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | Job.java | `core/src/main/java/hudson/model/Job.java` | 154-200行目でクラス定義と主要フィールドを確認 |

**主要処理フロー**:
- **294-305行目**: `isInQueue()`、`getQueueItem()`でキュー状態を取得
- **310-313行目**: `isBuilding()`でビルド中かどうかを判定
- **389-392行目**: `getNextBuildNumber()`で次のビルド番号を取得

### プログラム呼び出し階層図

```
index.jelly (ジョブ詳細画面)
    │
    ├─ sidepanel.jelly (サイドパネル)
    │      └─ 各種アクションリンク
    │
    ├─ jobpropertysummaries.jelly (プロパティサマリー)
    │      └─ JobProperty.getJobActions()
    │
    ├─ main.jelly (メインコンテンツ)
    │      └─ HistoryWidget (ビルド履歴)
    │              └─ Job.getBuilds()
    │
    └─ permalinks.jelly (パーマリンク)
           └─ Job.getPermalinks()
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLリクエスト ───▶ Staplerルーティング ───▶ index.jelly
                          │
                          ▼
                    Job.java
                    (モデル取得)
                          │
                          ▼
                    ┌─────────────────┐
                    │ displayName     │
                    │ description     │───▶ HTML
                    │ lastBuild       │     レスポンス
                    │ builds          │
                    │ permalinks      │
                    └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/hudson/model/Job/index.jelly` | テンプレート | メイン画面テンプレート |
| new-job-page.jelly | `core/src/main/resources/hudson/model/Job/new-job-page.jelly` | テンプレート | 新UI用テンプレート |
| sidepanel.jelly | `core/src/main/resources/hudson/model/Job/sidepanel.jelly` | テンプレート | サイドパネル |
| main.jelly | `core/src/main/resources/hudson/model/Job/main.jelly` | テンプレート | メインコンテンツ |
| permalinks.jelly | `core/src/main/resources/hudson/model/Job/permalinks.jelly` | テンプレート | パーマリンク表示 |
| jobpropertysummaries.jelly | `core/src/main/resources/hudson/model/Job/jobpropertysummaries.jelly` | テンプレート | プロパティサマリー |
| Job.java | `core/src/main/java/hudson/model/Job.java` | ソース | ジョブモデルクラス |
| Run.java | `core/src/main/java/hudson/model/Run.java` | ソース | ビルド実行クラス |
| HistoryWidget.java | `core/src/main/java/hudson/widgets/HistoryWidget.java` | ソース | ビルド履歴ウィジェット |
| BallColor.java | `core/src/main/java/hudson/BallColor.java` | ソース | ビルド状態アイコン |
