# 画面設計書 12-ジョブ設定

## 概要

本ドキュメントは、Jenkinsにおけるジョブ設定画面の設計仕様を記述したものです。ジョブの全般設定、ソースコード管理、ビルドトリガー、ビルドステップ等を設定するための包括的な設定画面です。

### 本画面の処理概要

**業務上の目的・背景**：ジョブ設定画面は、CI/CDパイプラインの動作を定義するための中核的な画面です。開発チームはこの画面を通じて、ソースコードの取得方法、ビルドの実行タイミング、ビルド手順、ビルド後の処理などを細かく設定します。プロジェクトの要件に応じてビルドパイプラインをカスタマイズし、自動化されたCI/CDワークフローを構築するために不可欠な機能を提供します。

**画面へのアクセス方法**：ジョブ詳細画面のサイドパネルにある「設定」リンクをクリック、または直接URLに`/job/{ジョブ名}/configure`を指定してアクセスします。新規ジョブ作成後は自動的にこの設定画面にリダイレクトされます。

**主要な操作・処理内容**：
1. ジョブの基本情報（説明、ビルド無効化）の設定
2. ジョブプロパティの設定（パラメータ定義、ビルド破棄設定等）
3. ソースコード管理（SCM）の設定
4. ビルドトリガーの設定（タイマー、SCMポーリング等）
5. ビルド環境の設定
6. ビルドステップの設定
7. ビルド後の処理の設定
8. 設定の保存・適用

**画面遷移**：
- 遷移元：ジョブ詳細、新規ジョブ作成
- 遷移先：ジョブ詳細（保存後）、再起動画面（設定変更により必要な場合）

**権限による表示制御**：
- `Job.EXTENDED_READ`権限があれば設定画面を閲覧可能（読み取り専用モード）
- `Job.CONFIGURE`権限がないと編集不可（readOnlyMode=true）
- 読み取り専用モードでは、すべての入力フィールドが無効化され、保存ボタンが非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | ジョブ（Job） | 主機能 | ジョブ設定の表示・編集 |
| 25 | SCM連携 | 補助機能 | ソースコード管理設定 |
| 23 | SCMトリガー | 補助機能 | ビルドトリガー設定 |
| 24 | タイマートリガー | 補助機能 | 定期実行トリガー設定 |
| 14 | ビルドステップ | 補助機能 | ビルドステップの設定 |
| 64 | フォームバリデーション | API連携 | 設定値の入力検証 |

## 画面種別

編集

## URL/ルーティング

```
/job/{ジョブ名}/configure
/job/{フォルダ名}/job/{ジョブ名}/configure
```

Staplerによりリクエストは`hudson.model.Job`クラスの`configure.jelly`にルーティングされます。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| description | 入力 | String | - | ジョブの説明（マークアップ対応） |
| disabled | 入力 | Boolean | - | ビルドを無効化するかどうか |
| properties | 入力 | List | - | ジョブプロパティのリスト |
| scm | 入力 | SCM | - | ソースコード管理設定 |
| triggers | 入力 | List | - | ビルドトリガーのリスト |
| buildWrappers | 入力 | List | - | ビルド環境設定のリスト |
| builders | 入力 | List | - | ビルドステップのリスト |
| publishers | 入力 | List | - | ビルド後処理のリスト |

## 表示項目

| 項目 | 説明 | データソース |
|------|------|------------|
| General | 基本設定セクション | ジョブタイプにより異なる |
| 説明 | ジョブの説明文入力エリア | `Job.description` |
| ビルド無効化 | ビルドを一時停止するチェックボックス | `Job.disabled` |
| プロパティ | 動的に追加されるジョブプロパティ | `JobPropertyDescriptor` |
| 設定エントリ | ジョブタイプ固有の設定項目 | `configure-entries.jelly` |

## イベント仕様

### 1-保存ボタン押下

設定内容をバリデーションし、問題なければconfig.xmlに保存してジョブ詳細画面へリダイレクトします。

- 処理フロー：
  1. クライアントサイドでフォームバリデーション実行
  2. POSTリクエストで`configSubmit`アクションへ送信
  3. サーバーサイドで`Job.doConfigSubmit()`が呼び出される
  4. JSONデータをパースしてジョブ設定を更新
  5. config.xmlファイルに永続化
  6. 成功時、ジョブ詳細画面へリダイレクト

### 2-適用ボタン押下

設定内容を保存しますが、画面遷移は行わず同じ画面にとどまります。

- 処理フロー：
  1. 保存と同様の処理を実行
  2. 成功時、画面をリロードせずに完了メッセージを表示

### 3-プロパティ追加

動的に追加可能なプロパティ（パラメータ定義等）を追加します。

- 処理フロー：
  1. 「追加」ボタンを押下
  2. ドロップダウンから追加するプロパティを選択
  3. 対応するDescriptorからフォームフラグメントを動的に読み込み
  4. フォームに追加

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | config.xml（ファイル） | UPDATE | ジョブ設定XMLの全体更新 |
| 適用ボタン押下 | config.xml（ファイル） | UPDATE | ジョブ設定XMLの全体更新 |

### テーブル別更新項目詳細

#### config.xml

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | description | ユーザー入力値 | マークアップ形式 |
| UPDATE | disabled | チェックボックス状態 | true/false |
| UPDATE | properties | プロパティリスト | XML形式でシリアライズ |
| UPDATE | triggers | トリガーリスト | XML形式でシリアライズ |
| UPDATE | builders | ビルドステップリスト | XML形式でシリアライズ |
| UPDATE | publishers | パブリッシャーリスト | XML形式でシリアライズ |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | メッセージ種別 |
|-------------|---------------|---------|--------------|
| Config | 設定 | 編集モード時のタイトル | 情報 |
| Configuration | 設定（読み取り専用） | 読み取り専用モード時のタイトル | 情報 |
| General | 全般 | セクションヘッダー | 情報 |
| Description | 説明 | フィールドラベル | 情報 |
| saved | 設定を保存しました | 保存成功時 | 成功 |
| validationError | 入力値に問題があります | バリデーションエラー時 | エラー |

## 例外処理

| 例外条件 | 処理内容 | 画面表示 |
|---------|---------|---------|
| 設定権限なし | 読み取り専用モードで表示 | フォームは表示されるが編集不可 |
| 閲覧権限なし | アクセス拒否 | 403エラー画面 |
| バリデーションエラー | エラーメッセージ表示、保存中止 | フィールド横にエラー表示 |
| 保存時の競合 | エラーメッセージ表示 | 再読み込みを促すメッセージ |
| FormException | フォーム処理エラー | エラー詳細を表示 |

## 備考

- ジョブタイプ（FreestyleProject、Pipeline等）によって表示される設定項目が異なります。派生クラスは`configure-entries.jelly`をオーバーライドして独自の設定項目を追加できます。
- プラグインにより追加される設定項目は、各Descriptorの`config.jelly`が動的にインクルードされます。
- サイドパネルにはセクションへのショートカットリンクが表示されます（`section-to-sidebar-items.js`により生成）。
- 大きなフォームでもスムーズに操作できるよう、スティッキーサイドパネルが使用されています。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ジョブ設定に関連するデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Job.java | `core/src/main/java/hudson/model/Job.java` | ジョブの基本プロパティとシリアライズ構造 |
| 1-2 | JobProperty.java | `core/src/main/java/hudson/model/JobProperty.java` | ジョブプロパティの抽象クラス |
| 1-3 | Descriptor.java | `core/src/main/java/hudson/model/Descriptor.java` | 設定フォームの基盤クラス |

**読解のコツ**: Jenkinsの設定システムはDescriptor/Describableパターンを使用しています。各設定可能な項目は対応するDescriptorを持ち、そのDescriptorが設定フォームのレンダリングとバリデーションを担当します。

#### Step 2: エントリーポイントを理解する

処理の起点となるJellyテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | configure.jelly | `core/src/main/resources/hudson/model/Job/configure.jelly` | ジョブ設定画面のメインテンプレート |

**主要処理フロー**:
1. **30行目**: `EXTENDED_READ`権限チェック
2. **31行目**: `readOnlyMode`の判定（CONFIGURE権限の有無）
3. **34行目**: サイドバー用JavaScriptの読み込み
4. **39-44行目**: スティッキーサイドパネルの設定
5. **47行目**: フォーム開始（`action="configSubmit"`）
6. **48-50行目**: 全般セクションヘッダーとビルド無効化チェックボックス
7. **57-61行目**: 説明入力エリア（マークアップ対応）
8. **63行目**: ジョブプロパティの動的リスト表示
9. **66行目**: 派生クラス固有の設定項目インクルード
10. **68行目**: 保存・適用ボタンバー

#### Step 3: フォーム処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Job.java | `core/src/main/java/hudson/model/Job.java` | `doConfigSubmit()`メソッドの実装 |
| 3-2 | FormApply.java | `core/src/main/java/hudson/util/FormApply.java` | フォーム送信処理のユーティリティ |

#### Step 4: プロパティシステムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | descriptorList.jelly | `core/src/main/resources/lib/form/descriptorList.jelly` | 動的プロパティリストの表示 |
| 4-2 | JobPropertyDescriptor.java | `core/src/main/java/hudson/model/JobPropertyDescriptor.java` | プロパティDescriptorの基底クラス |

### プログラム呼び出し階層図

```
configure.jelly (設定画面)
    │
    ├─ sidepanel.jelly (サイドパネル)
    │
    ├─ f:form (フォームコンポーネント)
    │      │
    │      ├─ f:entry (説明フィールド)
    │      │      └─ f:textarea (マークアップ対応テキストエリア)
    │      │
    │      ├─ f:descriptorList (プロパティリスト)
    │      │      └─ 各JobPropertyDescriptor.config.jelly
    │      │
    │      ├─ configure-entries.jelly (派生クラス固有)
    │      │      ├─ SCM設定
    │      │      ├─ トリガー設定
    │      │      ├─ ビルドステップ設定
    │      │      └─ パブリッシャー設定
    │      │
    │      └─ f:saveApplyBar (保存・適用ボタン)
    │
    └─ configSubmit (POSTアクション)
           └─ Job.doConfigSubmit()
                  └─ Job.save()
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ───▶ configSubmit ───▶ Job.doConfigSubmit()
                      │                    │
                      ▼                    ▼
              JSONパース              config.xml
              バリデーション              更新
                      │                    │
                      ▼                    ▼
              Job.submit()          リダイレクト
              properties更新         ジョブ詳細へ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| configure.jelly | `core/src/main/resources/hudson/model/Job/configure.jelly` | テンプレート | メイン設定画面 |
| configure-entries.jelly | `core/src/main/resources/hudson/model/Job/configure-entries.jelly` | テンプレート | 派生クラス用設定エントリ |
| Job.java | `core/src/main/java/hudson/model/Job.java` | ソース | ジョブモデル・設定処理 |
| JobProperty.java | `core/src/main/java/hudson/model/JobProperty.java` | ソース | ジョブプロパティ基底クラス |
| JobPropertyDescriptor.java | `core/src/main/java/hudson/model/JobPropertyDescriptor.java` | ソース | プロパティDescriptor |
| Descriptor.java | `core/src/main/java/hudson/model/Descriptor.java` | ソース | Descriptor基底クラス |
| FormApply.java | `core/src/main/java/hudson/util/FormApply.java` | ソース | フォーム処理ユーティリティ |
| section-to-sidebar-items.js | `core/src/main/resources/jsbundles/section-to-sidebar-items.js` | JavaScript | サイドバー生成 |
| descriptorList.jelly | `core/src/main/resources/lib/form/descriptorList.jelly` | テンプレート | 動的リスト表示 |
| saveApplyBar.jelly | `core/src/main/resources/lib/form/saveApplyBar.jelly` | テンプレート | 保存・適用ボタン |
