# 画面設計書 13-ビルド時間傾向

## 概要

本ドキュメントは、Jenkinsにおけるビルド時間傾向画面の設計仕様を記述したものです。ジョブのビルド時間の推移をグラフとテーブルで可視化し、パフォーマンスの傾向分析を支援する画面です。

### 本画面の処理概要

**業務上の目的・背景**：ビルド時間傾向画面は、CI/CDパイプラインのパフォーマンス監視とボトルネック特定のための重要な分析ツールです。開発チームはこの画面を通じて、ビルド時間が徐々に増加していないか、特定のビルドで異常に時間がかかっていないかを把握できます。ビルド時間の推移を視覚的に確認することで、コードベースの肥大化やテストの増加によるパフォーマンス劣化を早期に検知し、適切な対策を講じることができます。

**画面へのアクセス方法**：ジョブ詳細画面のサイドパネルにある「ビルド時間傾向」リンクをクリック、またはビルド詳細画面の所要時間リンクをクリックしてアクセスします。URLに直接`/job/{ジョブ名}/buildTimeTrend`を指定してアクセスすることも可能です。

**主要な操作・処理内容**：
1. ビルド時間のグラフ表示（PNG画像とイメージマップ）
2. ビルド一覧のテーブル表示（ソート可能）
3. 各ビルドの状態、ビルド番号、経過時間、所要時間、実行エージェントの表示
4. テーブルからビルド詳細画面およびコンソール出力への遷移

**画面遷移**：
- 遷移元：ジョブ詳細、ビルド詳細
- 遷移先：ビルド詳細、コンソール出力

**権限による表示制御**：
- `Job.READ`権限があれば閲覧可能
- エージェント列はノードが存在し、かつジョブがAbstractProjectの場合のみ表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | ジョブ（Job） | 主機能 | ジョブのビルド時間統計表示 |
| 6 | ビルド（Build） | 補助機能 | ビルド履歴データの取得 |

## 画面種別

一覧/統計

## URL/ルーティング

```
/job/{ジョブ名}/buildTimeTrend
/job/{フォルダ名}/job/{ジョブ名}/buildTimeTrend
```

Staplerによりリクエストは`hudson.model.Job`クラスの`buildTimeTrend.jelly`にルーティングされます。

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| builds | 出力 | RunList | ビルド一覧 |
| showAgent | 出力 | Boolean | エージェント列を表示するか |
| iconSize | 出力 | String | アイコンサイズ（16x16/24x24等） |

## 表示項目

| 項目 | 説明 | データソース |
|------|------|------------|
| ステータスアイコン | ビルド結果を示すアイコン | `Run.iconColor` |
| ビルド番号 | ビルド番号（リンク） | `Run.number` |
| 経過時間 | ビルドからの経過時間 | `Run.timestampString` |
| 所要時間 | ビルドの実行時間 | `Run.durationString` |
| エージェント | 実行したノード名 | `Executor.owner.node.displayName` |
| コンソールリンク | コンソール出力へのリンク | 固定 |
| ビルド時間グラフ | 時間推移のグラフ画像 | `buildTimeGraph/png` |

## イベント仕様

### 1-テーブルヘッダークリック（ソート）

テーブルヘッダーをクリックするとその列でソートされます。

- 処理フロー：
  1. sortableテーブルのJavaScriptがヘッダークリックを検知
  2. 指定列でテーブル行をクライアントサイドでソート
  3. ソート方向（昇順/降順）を切り替え

### 2-ビルド番号リンククリック

ビルド番号をクリックすると該当ビルドの詳細画面へ遷移します。

### 3-コンソールアイコンクリック

コンソールアイコンをクリックすると該当ビルドのコンソール出力画面へ遷移します。

### 4-グラフのイメージマップクリック

グラフ上の特定のビルドをクリックすると該当ビルドの詳細画面へ遷移します（イメージマップによる実装）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| （なし） | - | - | 本画面は参照専用で更新処理なし |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | メッセージ種別 |
|-------------|---------------|---------|--------------|
| title | ビルド時間傾向 - {ジョブ名} | ページタイトル | 情報 |
| Build Time Trend | ビルド時間傾向 | ヘッドライン | 情報 |
| S | S（ステータス） | テーブルヘッダー | 情報 |
| Build | ビルド | テーブルヘッダー | 情報 |
| Time Since | 経過時間 | テーブルヘッダー | 情報 |
| Duration | 所要時間 | テーブルヘッダー | 情報 |
| Agent | エージェント | テーブルヘッダー（条件付き） | 情報 |

## 例外処理

| 例外条件 | 処理内容 | 画面表示 |
|---------|---------|---------|
| ジョブが存在しない | 404エラー | 404エラー画面 |
| 権限不足 | アクセス拒否 | 403エラー画面 |
| ビルド履歴なし | 空のテーブルを表示 | テーブルボディが空 |
| グラフ生成エラー | 代替テキスト表示 | alt属性の文字列を表示 |

## 備考

- テーブルデータはProgressiveRenderingにより非同期で読み込まれます（`BuildTimeTrend`ハンドラー使用）。
- ビルド番号列は初期状態で降順ソートされています（`initialSortDir="up"`）。
- アイコンサイズは`t:setIconSize`タグで設定され、ユーザー設定に基づいて変更可能です。
- ステータスアイコンにはアニメーション版（実行中）と静的版があります。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ビルド時間データの構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Run.java | `core/src/main/java/hudson/model/Run.java` | duration、timestampフィールドの定義と取得メソッド |
| 1-2 | BuildTimeTrend.java | `core/src/main/java/jenkins/widgets/BuildTimeTrend.java` | テーブルデータ生成のハンドラー |

**読解のコツ**: Runクラスのdurationはミリ秒単位で保存され、durationStringは人間可読な形式に変換されます。

#### Step 2: エントリーポイントを理解する

処理の起点となるJellyテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | buildTimeTrend.jelly | `core/src/main/resources/hudson/model/Job/buildTimeTrend.jelly` | ビルド時間傾向画面のメインテンプレート |

**主要処理フロー**:
1. **29行目**: レイアウト設定（タイトルにジョブ名を含む）
2. **30行目**: サイドパネルのインクルード
3. **31行目**: パンくずリストの設定
4. **32行目**: 関連リソース（CSS/JS）のインクルード
5. **34-49行目**: ステータスアイコンのテンプレート定義
6. **50行目**: ヘッドラインの表示
7. **53行目**: BuildTimeTrendハンドラーの作成
8. **54行目**: ビルドリストの設定
9. **55行目**: showAgentフラグの判定（ノード存在＆AbstractProject）
10. **56行目**: ProgressiveRenderingの設定
11. **58-73行目**: テーブル定義（ヘッダー含む）
12. **76行目**: グラフ画像の表示

#### Step 3: 非同期データ読み込みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | BuildTimeTrend.java | `core/src/main/java/jenkins/widgets/BuildTimeTrend.java` | ProgressiveRenderingのハンドラー実装 |
| 3-2 | buildTimeTrend_resources.jelly | `core/src/main/resources/hudson/model/Job/buildTimeTrend_resources.jelly` | 関連JavaScript |

#### Step 4: グラフ生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Job.java | `core/src/main/java/hudson/model/Job.java` | buildTimeGraphのエンドポイント実装 |

### プログラム呼び出し階層図

```
buildTimeTrend.jelly (ビルド時間傾向画面)
    │
    ├─ sidepanel.jelly (サイドパネル)
    │
    ├─ BuildTimeTrend (ProgressiveRenderingハンドラー)
    │      │
    │      ├─ setBuilds() - ビルドリストの設定
    │      │
    │      └─ buildTimeTrend_displayBuilds() - JavaScript コールバック
    │             └─ テーブルボディにHTML追加
    │
    └─ buildTimeGraph/png (グラフ画像)
           │
           ├─ Job.getBuildTimeGraph()
           │      └─ JFreeChart でグラフ生成
           │
           └─ buildTimeGraph/map (イメージマップ)
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLリクエスト ───▶ buildTimeTrend.jelly ───▶ HTML初期表示
                                                 │
                                                 ▼
                  BuildTimeTrend ───────────▶ JSON データ
                  (Progressive)                  │
                      │                          ▼
                      ▼                  JavaScript
                  Job.getBuilds()        buildTimeTrend_displayBuilds()
                      │                          │
                      ▼                          ▼
                  Run データ ─────────────▶ テーブル行追加
                  (duration, number等)

buildTimeGraph/png ───▶ JFreeChart ───▶ PNG画像
                           │
                           ▼
buildTimeGraph/map ───▶ イメージマップHTML
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| buildTimeTrend.jelly | `core/src/main/resources/hudson/model/Job/buildTimeTrend.jelly` | テンプレート | メイン画面テンプレート |
| buildTimeTrend_resources.jelly | `core/src/main/resources/hudson/model/Job/buildTimeTrend_resources.jelly` | テンプレート | 関連リソース |
| BuildTimeTrend.java | `core/src/main/java/jenkins/widgets/BuildTimeTrend.java` | ソース | ProgressiveRenderingハンドラー |
| Job.java | `core/src/main/java/hudson/model/Job.java` | ソース | ジョブモデル・グラフ生成 |
| Run.java | `core/src/main/java/hudson/model/Run.java` | ソース | ビルド実行データ |
| sidepanel.jelly | `core/src/main/resources/hudson/model/Job/sidepanel.jelly` | テンプレート | サイドパネル |
| progressiveRendering.jelly | `core/src/main/resources/lib/layout/progressiveRendering.jelly` | テンプレート | 非同期レンダリング |
| setIconSize.jelly | `core/src/main/resources/lib/hudson/setIconSize.jelly` | テンプレート | アイコンサイズ設定 |
