# 画面設計書 14-ビルド詳細

## 概要

本ドキュメントは、Jenkinsにおけるビルド詳細画面の設計仕様を記述したものです。特定のビルド実行の結果、成果物、変更点、およびビルドに関連するアクションを表示する中心的な画面です。

### 本画面の処理概要

**業務上の目的・背景**：ビルド詳細画面は、CI/CDパイプラインの特定の実行結果を詳細に確認するための画面です。開発者はこの画面を通じて、ビルドの成功/失敗状況、実行時間、ビルド成果物、SCMの変更内容を確認できます。ビルドが失敗した場合の原因調査や、成功したビルドの成果物取得など、日常的な開発業務において頻繁に利用される重要な画面です。

**画面へのアクセス方法**：ジョブ詳細画面のビルド履歴からビルド番号をクリック、またはパーマリンク（最新ビルド、最新成功ビルド等）からアクセスできます。URLに直接`/job/{ジョブ名}/{ビルド番号}/`を指定してアクセスすることも可能です。

**主要な操作・処理内容**：
1. ビルド基本情報（ビルド番号、実行日時、所要時間）の表示
2. ビルド説明の表示・編集
3. ビルド成果物（アーティファクト）の一覧表示
4. ビルドアクションのサマリー表示
5. ビルドの保持/解除の制御

**画面遷移**：
- 遷移元：ジョブ詳細、コンソール出力、ビルド時間傾向
- 遷移先：コンソール出力、コンソール出力（フル）、ビルド設定、ビルド削除確認、成果物一覧

**権限による表示制御**：
- `Run.READ`権限がないとビルド詳細画面にアクセス不可
- `Run.UPDATE`権限がある場合のみ、説明編集ボタンとビルド保持ボタンが表示
- 新旧UIの切り替えは`NewBuildPageUserExperimentalFlag`フラグで制御

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | ビルド（Build） | 主機能 | ビルド結果の詳細表示 |
| 18 | 成果物アーカイブ | 補助機能 | ビルド成果物の表示 |
| 26 | 変更ログ | 補助機能 | SCM変更履歴の表示 |
| 65 | REST API | API連携 | ビルド情報のAPI提供 |

## 画面種別

詳細

## URL/ルーティング

```
/job/{ジョブ名}/{ビルド番号}/
/job/{フォルダ名}/job/{ジョブ名}/{ビルド番号}/
```

Staplerによりリクエストは`hudson.model.Run`クラスの`index.jelly`にルーティングされます。

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| displayName | 出力 | String | ビルドの表示名（通常は#番号） |
| description | 出力 | String | ビルドの説明（編集可能） |
| timestamp | 出力 | Calendar | ビルドの実行日時 |
| duration | 出力 | long | ビルドの所要時間（ミリ秒） |
| result | 出力 | Result | ビルド結果（SUCCESS, FAILURE等） |
| artifacts | 出力 | List | ビルド成果物のリスト |
| building | 出力 | boolean | ビルド実行中かどうか |

## 表示項目

| 項目 | 説明 | データソース |
|------|------|------------|
| ビルドキャプション | ビルド番号と実行日時 | `Run.displayName`, `Run.timestamp` |
| 説明 | ビルドの説明文（編集可能） | `Run.description` |
| 経過時間 | ビルド開始からの経過時間 | `Run.timestampString` |
| 所要時間 | ビルドの実行時間 | `Run.durationString` |
| 成果物一覧 | ビルドで生成されたファイル | `t:artifactList` |
| アクションサマリー | 各アクションの要約表示 | `Action.summary.jelly` |

## イベント仕様

### 1-説明編集ボタン押下

`Run.UPDATE`権限がある場合に表示される編集ボタン。押下すると説明文をインライン編集できます。

- 処理フロー：
  1. 編集モードへの切り替え（JavaScript）
  2. テキストエリアでの編集
  3. 保存時にPOSTリクエストで`submitDescription`へ送信
  4. 成功後、画面を更新

### 2-ビルド保持ボタン押下

ビルドをログローテーションから除外して永続保持します。

- 処理フロー：
  1. `logKeep.jelly`のフォームを表示
  2. 保持/解除のトグルボタンを押下
  3. POSTリクエストで`toggleLogKeep`アクションへ送信
  4. `Run.keepLog`フラグを更新

### 3-成果物リンククリック

成果物ファイル名をクリックするとファイルをダウンロードまたは表示します。

### 4-コンソール出力リンククリック

サイドパネルの「コンソール出力」をクリックすると、コンソール出力画面へ遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 説明編集・保存 | build.xml（ファイル） | UPDATE | ビルド設定XMLの更新 |
| ビルド保持設定 | build.xml（ファイル） | UPDATE | keepLogフラグの更新 |

### テーブル別更新項目詳細

#### build.xml

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | description | ユーザー入力値 | マークアップ形式 |
| UPDATE | keepLog | true/false | ビルド保持フラグ |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | メッセージ種別 |
|-------------|---------------|---------|--------------|
| startedAgo | {時間}前に開始 | 常時 | 情報 |
| beingExecuted | {時間}実行中 | ビルド実行中 | 情報 |
| Took | 所要時間 | ビルド完了後 | 情報 |
| Build Artifacts | ビルド成果物 | 成果物がある場合 | 情報 |

## 例外処理

| 例外条件 | 処理内容 | 画面表示 |
|---------|---------|---------|
| ビルドが存在しない | 404エラー | 404エラー画面 |
| 権限不足 | アクセス拒否 | 403エラー画面 |
| ビルドデータ読み込みエラー | エラーログ出力 | エラーメッセージ表示 |

## 備考

- 新UIと旧UIの切り替えは`NewBuildPageUserExperimentalFlag`で制御されます。新UIを有効にした場合、`new-build-page.jelly`がレンダリングされます。
- ビルド実行中の場合、所要時間の代わりに「実行中」のメッセージが表示されます。
- 各アクション（テスト結果、コード品質等）は自身の`summary.jelly`を持ち、動的にインクルードされます。
- 成果物一覧は`t:artifactList`タグで表示され、ファイルサイズの制限を超える場合は省略表示されます。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ビルド実行のデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Run.java | `core/src/main/java/hudson/model/Run.java` | ビルドの基本クラス。number、result、timestamp、durationを理解 |
| 1-2 | Result.java | `core/src/main/java/hudson/model/Result.java` | ビルド結果の列挙型（SUCCESS, FAILURE等） |
| 1-3 | Artifact.java | `core/src/main/java/hudson/model/Run.java` | Runクラス内のArtifact内部クラス |

**読解のコツ**: Runクラスは抽象クラスで、具体的な実装はBuild等の派生クラスにあります。`@Exported`アノテーションはREST APIで公開されるプロパティを示します。

#### Step 2: エントリーポイントを理解する

処理の起点となるJellyテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/model/Run/index.jelly` | ビルド詳細画面のメインテンプレート |

**主要処理フロー**:
1. **28行目**: `newBuildPage`フラグによる新旧UI切り替え判定
2. **30-33行目**: 新UIの場合は`new-build-page.jelly`をインクルード
3. **35行目**: レイアウト設定（タイトルにfullDisplayNameを使用）
4. **36行目**: サイドパネルのインクルード
5. **40-45行目**: コントロールボタン（説明編集、ビルド保持）の設定
6. **47行目**: ビルドキャプションの表示（番号と日時）
7. **49-51行目**: 編集可能な説明の表示
8. **53-66行目**: 経過時間・所要時間の表示
9. **69-70行目**: 成果物一覧の表示
10. **72-75行目**: アクションサマリーのループ処理
11. **77行目**: オプショナルなサマリーのインクルード
12. **80行目**: メインコンテンツのインクルード

#### Step 3: サイドパネルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | sidepanel.jelly | `core/src/main/resources/hudson/model/Run/sidepanel.jelly` | サイドパネルのアクションリンク |

#### Step 4: 成果物表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | artifactList.jelly | `core/src/main/resources/lib/hudson/artifactList.jelly` | 成果物一覧の表示コンポーネント |

#### Step 5: ビルド保持機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | logKeep.jelly | `core/src/main/resources/hudson/model/Run/logKeep.jelly` | ビルド保持ボタンの表示 |

### プログラム呼び出し階層図

```
index.jelly (ビルド詳細画面)
    │
    ├─ sidepanel.jelly (サイドパネル)
    │      └─ 各種アクションリンク（コンソール、設定、削除等）
    │
    ├─ t:buildCaption (ビルドキャプション)
    │      └─ displayName + timestamp
    │
    ├─ t:editableDescription (説明編集)
    │      └─ Run.description
    │
    ├─ logKeep.jelly (ビルド保持)
    │      └─ Run.keepLog
    │
    ├─ t:artifactList (成果物一覧)
    │      └─ Run.getArtifacts()
    │
    ├─ Action.summary.jelly (各アクションのサマリー)
    │      └─ Run.getAllActions()
    │
    ├─ summary.jelly (オプショナルサマリー)
    │
    └─ main.jelly (メインコンテンツ)
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLリクエスト ───▶ Staplerルーティング ───▶ index.jelly
  /{番号}/                │
                          ▼
                    Run.java
                    (モデル取得)
                          │
                          ▼
                    ┌─────────────────┐
                    │ displayName     │
                    │ description     │
                    │ timestamp       │───▶ HTML
                    │ duration        │     レスポンス
                    │ result          │
                    │ artifacts       │
                    │ allActions      │
                    └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/hudson/model/Run/index.jelly` | テンプレート | メイン画面テンプレート |
| new-build-page.jelly | `core/src/main/resources/hudson/model/Run/new-build-page.jelly` | テンプレート | 新UI用テンプレート |
| sidepanel.jelly | `core/src/main/resources/hudson/model/Run/sidepanel.jelly` | テンプレート | サイドパネル |
| logKeep.jelly | `core/src/main/resources/hudson/model/Run/logKeep.jelly` | テンプレート | ビルド保持ボタン |
| details.jelly | `core/src/main/resources/hudson/model/Run/details.jelly` | テンプレート | 追加詳細情報 |
| summary.jelly | `core/src/main/resources/hudson/model/Run/summary.jelly` | テンプレート | サマリー情報 |
| main.jelly | `core/src/main/resources/hudson/model/Run/main.jelly` | テンプレート | メインコンテンツ |
| Run.java | `core/src/main/java/hudson/model/Run.java` | ソース | ビルド実行クラス |
| Result.java | `core/src/main/java/hudson/model/Result.java` | ソース | ビルド結果列挙型 |
| artifactList.jelly | `core/src/main/resources/lib/hudson/artifactList.jelly` | テンプレート | 成果物一覧コンポーネント |
| buildCaption.jelly | `core/src/main/resources/lib/hudson/buildCaption.jelly` | テンプレート | ビルドキャプション |
| editableDescription.jelly | `core/src/main/resources/lib/hudson/editableDescription.jelly` | テンプレート | 編集可能説明 |
