# 画面設計書 15-コンソール出力

## 概要

本ドキュメントは、Jenkinsにおけるコンソール出力画面の設計仕様を記述したものです。ビルド実行時のログ出力をリアルタイムまたは完了後に表示する画面です。

### 本画面の処理概要

**業務上の目的・背景**：コンソール出力画面は、ビルドの実行状況をリアルタイムで監視し、問題発生時の原因究明を行うための重要な画面です。開発者はこの画面を通じて、ビルドスクリプトの出力、テストの実行結果、エラーメッセージ、警告などを確認できます。ビルドが失敗した場合の迅速なデバッグや、ビルドプロセスの進行状況の確認に不可欠な機能を提供します。

**画面へのアクセス方法**：ビルド詳細画面のサイドパネルにある「コンソール出力」リンクをクリック、またはジョブ詳細画面のビルド履歴からコンソールアイコンをクリックしてアクセスできます。URLに直接`/job/{ジョブ名}/{ビルド番号}/console`を指定することも可能です。

**主要な操作・処理内容**：
1. ビルドログのリアルタイム表示（ビルド実行中の場合）
2. ビルドログの全体表示（ビルド完了後）
3. ログのダウンロード
4. ログのクリップボードへのコピー
5. プレーンテキスト表示への切り替え

**画面遷移**：
- 遷移元：ビルド詳細、ジョブ詳細（ビルド履歴）、ビルド時間傾向
- 遷移先：コンソール出力（フル）、プレーンテキストビュー

**権限による表示制御**：
- `Run.READ`権限があれば閲覧可能
- ログファイルのサイズが大きい場合、自動的にページネーションまたは省略表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | ビルド（Build） | 主機能 | ビルドログのリアルタイム表示 |
| 8 | エグゼキューター | 補助機能 | 実行中ビルドの状態表示 |

## 画面種別

詳細/ログ表示

## URL/ルーティング

```
/job/{ジョブ名}/{ビルド番号}/console
/job/{フォルダ名}/job/{ジョブ名}/{ビルド番号}/console
```

Staplerによりリクエストは`hudson.model.Run`クラスの`console.jelly`にルーティングされます。

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| consoleText | 出力 | AnnotatedLargeText | コンソールログ（アノテーション付き） |
| displayName | 出力 | String | ビルドの表示名 |

## 表示項目

| 項目 | 説明 | データソース |
|------|------|------------|
| コンソールログ | ビルド実行のログ出力 | `console-log.jelly` |
| ダウンロードボタン | ログファイルのダウンロード | `consoleText`エンドポイント |
| コピーボタン | ログのクリップボードコピー | `l:copyButton` |
| プレーンテキストリンク | テキスト形式での表示 | `consoleText`エンドポイント |

## イベント仕様

### 1-ダウンロードボタン押下

ログファイルをテキストファイルとしてダウンロードします。

- 処理フロー：
  1. `consoleText`エンドポイントにアクセス
  2. Content-Disposition: attachmentヘッダー付きでレスポンス
  3. ファイル名は`{ビルド表示名}.txt`

### 2-コピーボタン押下

ログ内容をクリップボードにコピーします。

- 処理フロー：
  1. `l:copyButton`コンポーネントがクリックを検知
  2. `ref="out"`で指定された要素のテキストを取得
  3. クリップボードAPIでコピー

### 3-プレーンテキスト表示リンククリック

ログをプレーンテキスト形式で表示します。

- 処理フロー：
  1. `consoleText`エンドポイントにリダイレクト
  2. Content-Type: text/plainでレスポンス

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| （なし） | - | - | 本画面は参照専用で更新処理なし |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | メッセージ種別 |
|-------------|---------------|---------|--------------|
| Console | コンソール | アプリバータイトル | 情報 |
| Download | ダウンロード | ダウンロードボタン | 情報 |
| Copy | コピー | コピーボタン | 情報 |
| View as plain text | プレーンテキストで表示 | リンクテキスト | 情報 |

## 例外処理

| 例外条件 | 処理内容 | 画面表示 |
|---------|---------|---------|
| ビルドが存在しない | 404エラー | 404エラー画面 |
| 権限不足 | アクセス拒否 | 403エラー画面 |
| ログファイルが存在しない | 空のログを表示 | 空のコンソール表示 |
| ログファイル読み込みエラー | エラーログ出力 | エラーメッセージ表示 |

## 備考

- ビルド実行中はログがリアルタイムで更新されます（Progressive HTML）。
- ログには色付きのANSIエスケープシーケンスがHTML形式に変換されて表示されます。
- ConsoleNoteによるアノテーション（リンク、ハイライト等）が適用されます。
- `consoleFull`変数がtrueの場合、ページネーションなしで全ログが表示されます（コンソール出力（フル）画面）。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、コンソールログのデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AnnotatedLargeText.java | `core/src/main/java/hudson/console/AnnotatedLargeText.java` | アノテーション付きログテキストの管理 |
| 1-2 | ConsoleNote.java | `core/src/main/java/hudson/console/ConsoleNote.java` | コンソールアノテーションの基底クラス |

**読解のコツ**: コンソールログはAnnotatedLargeTextとして管理され、ConsoleNoteによるアノテーションが埋め込まれています。

#### Step 2: エントリーポイントを理解する

処理の起点となるJellyテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | console.jelly | `core/src/main/resources/hudson/model/Run/console.jelly` | コンソール出力画面のメインテンプレート |

**主要処理フロー**:
1. **32-34行目**: ConsoleTabオブジェクトの作成
2. **36行目**: `l:run-subpage`レイアウトの使用
3. **37行目**: アプリバータイトル「Console」の設定
4. **38-41行目**: ダウンロードボタンの表示
5. **42行目**: コピーボタンの表示
6. **43-45行目**: プレーンテキスト表示リンク
7. **48行目**: `it`変数をRunオブジェクトに設定
8. **49行目**: `console-log.jelly`のインクルード

#### Step 3: ログ表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | console-log.jelly | `core/src/main/resources/hudson/model/Run/console-log.jelly` | 実際のログ表示コンポーネント |
| 3-2 | ConsoleTab.java | `core/src/main/java/jenkins/run/ConsoleTab.java` | コンソールタブのラッパークラス |

### プログラム呼び出し階層図

```
console.jelly (コンソール出力画面)
    │
    ├─ ConsoleTab (ラッパーオブジェクト)
    │      └─ Run (ビルドオブジェクト)
    │
    ├─ l:run-subpage (レイアウト)
    │      │
    │      ├─ l:app-bar (アプリバー)
    │      │      ├─ ダウンロードボタン
    │      │      ├─ コピーボタン
    │      │      └─ プレーンテキストリンク
    │      │
    │      └─ console-log.jelly (ログ表示)
    │             └─ AnnotatedLargeText
    │                    └─ ConsoleNote (アノテーション)
    │
    └─ consoleText (エンドポイント)
           └─ プレーンテキストログ
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLリクエスト ───▶ console.jelly ───▶ HTML表示
  /console                │
                          ▼
                    ConsoleTab
                          │
                          ▼
                    console-log.jelly
                          │
                          ▼
                    AnnotatedLargeText
                    (ログファイル読み込み)
                          │
                          ▼
                    ConsoleNote
                    (アノテーション処理)
                          │
                          ▼
                    HTML形式のログ出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| console.jelly | `core/src/main/resources/hudson/model/Run/console.jelly` | テンプレート | メイン画面テンプレート |
| console-log.jelly | `core/src/main/resources/hudson/model/Run/console-log.jelly` | テンプレート | ログ表示コンポーネント |
| consoleFull.jelly | `core/src/main/resources/hudson/model/Run/consoleFull.jelly` | テンプレート | フル表示用ラッパー |
| ConsoleTab.java | `core/src/main/java/jenkins/run/ConsoleTab.java` | ソース | コンソールタブラッパー |
| AnnotatedLargeText.java | `core/src/main/java/hudson/console/AnnotatedLargeText.java` | ソース | アノテーション付きログ |
| ConsoleNote.java | `core/src/main/java/hudson/console/ConsoleNote.java` | ソース | アノテーション基底クラス |
| Run.java | `core/src/main/java/hudson/model/Run.java` | ソース | ビルド実行クラス |
| run-subpage.jelly | `core/src/main/resources/lib/layout/run-subpage.jelly` | テンプレート | サブページレイアウト |
| copyButton.jelly | `core/src/main/resources/lib/layout/copyButton.jelly` | テンプレート | コピーボタンコンポーネント |
